/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class FileImporterTest
extends TestCase {
    String location;
    String title;
    int nodeCount;
    int edgeCount;
    CyNetwork network;

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testGMLImport() throws Exception {
        this.location = "testData/gal.gml";
        this.network = Cytoscape.createNetworkFromFile(this.location);
        this.title = this.network.getTitle();
        FileImporterTest.assertEquals((String)"gal.gml", (String)this.title);
        this.nodeCount = this.network.getNodeCount();
        FileImporterTest.assertEquals((String)"number of nodes", (int)11, (int)this.nodeCount);
        this.edgeCount = this.network.getEdgeCount();
        FileImporterTest.assertEquals((String)"number of edges", (int)10, (int)this.edgeCount);
    }

    public void testXGMMLImport() throws Exception {
        this.location = "testData/galFiltered2.xgmml";
        this.network = Cytoscape.createNetworkFromFile(this.location, false);
        this.title = this.network.getTitle();
        FileImporterTest.assertEquals((String)"GAL Filtered (Yeast)", (String)this.title);
        this.nodeCount = this.network.getNodeCount();
        FileImporterTest.assertEquals((String)"num nodes", (int)331, (int)this.nodeCount);
        this.edgeCount = this.network.getEdgeCount();
        FileImporterTest.assertEquals((String)"num edges", (int)362, (int)this.edgeCount);
    }

    public void testSIFImport() throws Exception {
        this.location = "testData/galFiltered.sif";
        this.network = Cytoscape.createNetworkFromFile(this.location, false);
        this.title = this.network.getTitle();
        FileImporterTest.assertEquals((String)"galFiltered.sif", (String)this.title);
        this.nodeCount = this.network.getNodeCount();
        FileImporterTest.assertEquals((String)"num nodes", (int)331, (int)this.nodeCount);
        this.edgeCount = this.network.getEdgeCount();
        FileImporterTest.assertEquals((String)"num edge", (int)362, (int)this.edgeCount);
    }

    public static void main(String[] args) {
        TestRunner.run(FileImporterTest.class);
    }
}

