/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.data.FlagEvent;
import cytoscape.data.FlagEventListener;
import cytoscape.data.SelectEvent;
import cytoscape.data.SelectEventListener;
import cytoscape.data.SelectFilter;
import giny.filter.Filter;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.GraphPerspectiveChangeEvent;
import giny.model.GraphPerspectiveChangeListener;
import giny.model.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class FlagFilter
implements Filter,
GraphPerspectiveChangeListener {
    protected SelectFilter selectFilter;
    protected SelectEventListener myListener = new SelectEventListener(){

        public void onSelectEvent(SelectEvent event) {
            FlagFilter.this.fireEvent(event.getTarget(), event.getEventType());
        }
    };
    List listeners = new ArrayList();

    public FlagFilter(GraphPerspective graph) {
        this.selectFilter = new SelectFilter(graph);
        this.selectFilter.addSelectEventListener(this.myListener);
    }

    public FlagFilter(SelectFilter selectFilter) {
        this.selectFilter = selectFilter;
        this.selectFilter.addSelectEventListener(this.myListener);
    }

    public Set getFlaggedNodes() {
        return this.selectFilter.getSelectedNodes();
    }

    public Set getFlaggedEdges() {
        return this.selectFilter.getSelectedEdges();
    }

    public boolean isFlagged(Node node) {
        return this.selectFilter.isSelected(node);
    }

    public boolean isFlagged(Edge edge) {
        return this.selectFilter.isSelected(edge);
    }

    public boolean passesFilter(Object o) {
        return this.selectFilter.passesFilter(o);
    }

    public boolean setFlagged(Node node, boolean newState) {
        return this.selectFilter.setSelected(node, newState);
    }

    public boolean setFlagged(Edge edge, boolean newState) {
        return this.selectFilter.setSelected(edge, newState);
    }

    public Set setFlaggedNodes(Collection nodesToSet, boolean newState) {
        return this.selectFilter.setSelectedNodes(nodesToSet, newState);
    }

    public Set setFlaggedEdges(Collection edgesToSet, boolean newState) {
        return this.selectFilter.setSelectedEdges(edgesToSet, newState);
    }

    public Set flagAllNodes() {
        return this.selectFilter.selectAllNodes();
    }

    public Set flagAllEdges() {
        return this.selectFilter.selectAllEdges();
    }

    public Set unflagAllNodes() {
        return this.selectFilter.unselectAllNodes();
    }

    public Set unflagAllEdges() {
        return this.selectFilter.unselectAllEdges();
    }

    public void graphPerspectiveChanged(GraphPerspectiveChangeEvent event) {
        this.selectFilter.graphPerspectiveChanged(event);
    }

    public void addFlagEventListener(FlagEventListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeFlagEventListener(FlagEventListener listener) {
        this.listeners.remove(listener);
    }

    public List getFlagEventListeners() {
        return this.listeners;
    }

    protected void fireEvent(Object target, boolean selectOn) {
        FlagEvent event = new FlagEvent(this, target, selectOn);
        for (FlagEventListener listener : this.listeners) {
            listener.onFlagEvent(event);
        }
    }
}

