/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.actions.LoadNetworkTask;
import cytoscape.dialogs.ImportNetworkDialog;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyMenus;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBException;

public class ImportGraphFileAction
extends CytoscapeAction {
    protected CyMenus windowMenu;

    public ImportGraphFileAction(CyMenus windowMenu) {
        super("Network (multiple file types)...");
        this.setPreferredMenu("File.Import");
        this.setAcceleratorCombo(76, 2);
        this.windowMenu = windowMenu;
        this.setName("load");
    }

    public ImportGraphFileAction(CyMenus windowMenu, boolean label) {
        this.windowMenu = windowMenu;
    }

    public void actionPerformed(ActionEvent e) {
        ImportNetworkDialog fd = null;
        try {
            fd = new ImportNetworkDialog((Frame)Cytoscape.getDesktop(), true);
        }
        catch (JAXBException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        fd.pack();
        fd.setLocationRelativeTo(Cytoscape.getDesktop());
        fd.setVisible(true);
        if (!fd.getStatus()) {
            return;
        }
        File[] files = fd.getFiles();
        boolean skipMessage = false;
        if (files != null && files.length != 0) {
            if (files.length != 1) {
                skipMessage = true;
            }
            ArrayList<String> messages = new ArrayList<String>();
            messages.add("Successfully loaded the following files:");
            messages.add(" ");
            for (int i = 0; i < files.length; ++i) {
                if (fd.isRemote()) {
                    messages.add(fd.getURLStr());
                } else {
                    messages.add(files[i].getName());
                }
                LoadNetworkTask.loadFile(files[i], skipMessage);
            }
            if (files.length != 1) {
                JOptionPane messagePane = new JOptionPane();
                messagePane.setLocation(Cytoscape.getDesktop().getLocationOnScreen());
                JOptionPane.showMessageDialog(Cytoscape.getDesktop(), messages.toArray(), "Multiple Network Files Loaded", 1);
            }
        }
    }
}

