/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.readers.GMLParser;
import cytoscape.data.readers.GMLReader;
import cytoscape.data.readers.GMLWriter;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.view.CyNetworkView;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

class ExportAsGMLTask
implements Task {
    private String fileName;
    private CyNetwork network;
    private CyNetworkView view;
    private TaskMonitor taskMonitor;

    ExportAsGMLTask(String fileName, CyNetwork network, CyNetworkView view) {
        this.fileName = fileName;
        this.network = network;
        this.view = view;
    }

    public void run() {
        this.taskMonitor.setStatus("Saving Network...");
        this.taskMonitor.setPercentCompleted(-1);
        try {
            int numNodes = this.network.getNodeCount();
            if (numNodes == 0) {
                throw new IllegalArgumentException("Network is empty.");
            }
            this.saveGraph();
            this.taskMonitor.setPercentCompleted(100);
            this.taskMonitor.setStatus("Network successfully saved to:  " + this.fileName);
        }
        catch (IllegalArgumentException e) {
            this.taskMonitor.setException(e, "Network is Empty.  Cannot be saved.");
        }
        catch (IOException e) {
            this.taskMonitor.setException(e, "Unable to save network.");
        }
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Saving Network");
    }

    private void saveGraph() throws IOException {
        FileWriter fileWriter = new FileWriter(this.fileName);
        Vector list = null;
        GMLReader reader = (GMLReader)this.network.getClientData("GML");
        list = reader != null ? reader.getList() : new Vector();
        GMLWriter gmlWriter = new GMLWriter();
        gmlWriter.writeGML(this.network, this.view, list);
        GMLParser.printList(list, fileWriter);
        fileWriter.close();
        Object[] ret_val = new Object[]{this.network, new File(this.fileName).toURI(), new Integer(Cytoscape.FILE_GML)};
        Cytoscape.firePropertyChange("NETWORK_SAVED", null, ret_val);
    }
}

