/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import giny.model.GraphPerspectiveChangeEvent;
import giny.model.GraphPerspectiveChangeListener;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BugHideNodeEventFiringTest
extends TestCase
implements GraphPerspectiveChangeListener {
    private boolean _edgeHiddenCallback;

    public static Test suite() {
        return new TestSuite(BugHideNodeEventFiringTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)BugHideNodeEventFiringTest.suite());
    }

    public void testBug() {
        CyNode CN1 = Cytoscape.getCyNode("CN1", true);
        CyNode S = Cytoscape.getCyNode("S", true);
        CyEdge e1 = Cytoscape.getCyEdge(CN1, S, "interaction", "testInteraction", true, true);
        CyNetwork net = Cytoscape.createNetwork("net", false);
        net.restoreNode(CN1);
        net.restoreNode(S);
        net.restoreEdge(e1);
        net.addGraphPerspectiveChangeListener(this);
        this._edgeHiddenCallback = false;
        net.hideNode(CN1);
        net.removeGraphPerspectiveChangeListener(this);
    }

    public void graphPerspectiveChanged(GraphPerspectiveChangeEvent e) {
        int[] hiddenEdges;
        int[] hiddenNodes;
        if (e.isNodesHiddenType() && (hiddenNodes = e.getHiddenNodeIndices()) != null && this._edgeHiddenCallback) {
            Assert.fail((String)"We received hidden edge event callback BEFORE hidden node event callback!");
        }
        if (e.isEdgesHiddenType() && (hiddenEdges = e.getHiddenEdgeIndices()) != null) {
            this._edgeHiddenCallback = true;
        }
    }
}

