/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.ListItem;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.text.RtfChunk;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfListItem
extends RtfParagraph {
    private RtfList parentList = null;
    private boolean containsInnerList = false;

    public RtfListItem(RtfDocument rtfDocument, ListItem listItem) {
        super(rtfDocument, listItem);
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < this.chunks.size(); ++i) {
                RtfBasicElement rtfBasicElement = (RtfBasicElement)this.chunks.get(i);
                if (rtfBasicElement instanceof RtfChunk) {
                    ((RtfChunk)rtfBasicElement).setSoftLineBreaks(true);
                } else if (rtfBasicElement instanceof RtfList) {
                    byteArrayOutputStream.write(RtfParagraph.PARAGRAPH);
                    this.containsInnerList = true;
                }
                byteArrayOutputStream.write(rtfBasicElement.write());
                if (!(rtfBasicElement instanceof RtfList)) continue;
                byteArrayOutputStream.write(this.parentList.writeListBeginning());
                byteArrayOutputStream.write("\\tab".getBytes());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writeDefinition() {
        for (int i = 0; i < this.chunks.size(); ++i) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.chunks.get(i);
            if (!(rtfBasicElement instanceof RtfList)) continue;
            return ((RtfList)rtfBasicElement).writeDefinition();
        }
        return new byte[0];
    }

    public void inheritListSettings(int n, int n2) {
        for (int i = 0; i < this.chunks.size(); ++i) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.chunks.get(i);
            if (!(rtfBasicElement instanceof RtfList)) continue;
            ((RtfList)rtfBasicElement).setListNumber(n);
            ((RtfList)rtfBasicElement).setListLevel(n2);
            ((RtfList)rtfBasicElement).setParent(this.parentList);
        }
    }

    protected void correctIndentation() {
        for (int i = 0; i < this.chunks.size(); ++i) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.chunks.get(i);
            if (!(rtfBasicElement instanceof RtfList)) continue;
            ((RtfList)rtfBasicElement).correctIndentation();
        }
    }

    public void setParent(RtfList rtfList) {
        this.parentList = rtfList;
    }

    public boolean isContainsInnerList() {
        return this.containsInnerList;
    }
}

