/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class ChooseOntologyPanel
extends JPanel
implements ActionListener {
    private final String NONE = "---";
    private final String PROCESS = "GO Biological Process";
    private final String FUNCTION = "GO Molecular Function";
    private final String COMPONENT = "GO Cellular Component";
    private final String GO_FULL = "full GO";
    private final String GOSLIM_GENERIC = "GOSlim generic";
    private final String GOSLIM_GOA = "GOSlim goa";
    private final String GOSLIM_PLANTS = "GOSlim plants";
    private final String GOSLIM_YEAST = "GOSlim yeast";
    private final String CUSTOM = "Custom...";
    private final String[] choiceArray = new String[]{"---", "GO Biological Process", "GO Molecular Function", "GO Cellular Component", "full GO", "GOSlim generic", "GOSlim goa", "GOSlim plants", "GOSlim yeast", "Custom..."};
    private JComboBox choiceBox;
    private File openFile = null;
    private Component settingsPanel;
    private boolean def = true;
    private String bingoDir;
    private File annotationFilePath;

    public ChooseOntologyPanel(Component settingsPanel, String bingoDir) {
        this.bingoDir = bingoDir;
        this.settingsPanel = settingsPanel;
        this.annotationFilePath = new File(bingoDir, "BiNGO");
        this.setOpaque(false);
        this.makeJComponents();
        this.setLayout(new GridLayout(1, 0));
        this.add(this.choiceBox);
        this.choiceBox.setSelectedItem("GO Biological Process");
        this.openFile = new File(this.annotationFilePath, "GO_Biological_Process");
        this.def = true;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void makeJComponents() {
        this.choiceBox = new JComboBox<String>(this.choiceArray);
        this.choiceBox.setEditable(false);
        this.choiceBox.addActionListener(this);
    }

    public File getFile() {
        return this.openFile;
    }

    public String getSelection() {
        return this.choiceBox.getSelectedItem().toString();
    }

    public boolean getDefault() {
        return this.def;
    }

    public void actionPerformed(ActionEvent event) {
        if (this.choiceBox.getSelectedItem().equals("GO Biological Process")) {
            this.openFile = new File(this.annotationFilePath, "GO_Biological_Process");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("GO Molecular Function")) {
            this.openFile = new File(this.annotationFilePath, "GO_Molecular_Function");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("GO Cellular Component")) {
            this.openFile = new File(this.annotationFilePath, "GO_Cellular_Component");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("full GO")) {
            this.openFile = new File(this.annotationFilePath, "GO_Full");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("GOSlim generic")) {
            this.openFile = new File(this.annotationFilePath, "GOSlim_Generic");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("GOSlim goa")) {
            this.openFile = new File(this.annotationFilePath, "GOSlim_GOA");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("GOSlim plants")) {
            this.openFile = new File(this.annotationFilePath, "GOSlim_Plants");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("GOSlim yeast")) {
            this.openFile = new File(this.annotationFilePath, "GOSlim_Yeast");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Custom...")) {
            JFileChooser chooser = new JFileChooser(this.bingoDir);
            int returnVal = chooser.showOpenDialog(this.settingsPanel);
            if (returnVal == 0) {
                this.openFile = chooser.getSelectedFile();
                this.choiceBox.setEditable(true);
                this.choiceBox.setSelectedItem(this.openFile.toString());
                this.choiceBox.setEditable(false);
                this.def = false;
            }
            if (returnVal == 1) {
                this.choiceBox.setSelectedItem("---");
                this.openFile = null;
                this.def = true;
            }
        } else {
            this.choiceBox.setSelectedItem("---");
            this.openFile = null;
            this.def = true;
        }
    }
}

