/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.Cytoscape;
import cytoscape.data.readers.GMLReader;
import cytoscape.data.readers.GraphReader;
import cytoscape.visual.DuplicateCalculatorNameException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class VisualStyleBuilderDialog
extends JDialog {
    private String mapperSuffix;
    private String VSName;
    private GMLReader gmlReader;
    private JButton generateButton;
    private JSeparator jSeparator1;
    private JLabel mapperLabel;
    private JTextField mapperTextField;
    private JEditorPane messageEditorPane;
    private JScrollPane messageScrollPane;
    private JLabel styleNameLabel;
    private JTextField styleNameTextField;
    private JLabel titleLabel;
    private JButton skipButton;

    public VisualStyleBuilderDialog(String networkName, GraphReader reader, Frame parent, boolean modal) {
        super(parent, modal);
        this.gmlReader = (GMLReader)reader;
        String modName = "";
        String[] removeDot = networkName.split("\\.");
        for (int idx = 0; idx < removeDot.length; ++idx) {
            modName = modName + removeDot[idx];
            if (idx == removeDot.length - 1) continue;
            modName = modName + "_";
        }
        this.mapperSuffix = " for " + modName;
        this.VSName = "GML style for " + modName;
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle("Visual Style Builder");
        this.titleLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.styleNameTextField = new JTextField();
        this.styleNameLabel = new JLabel();
        this.generateButton = new JButton();
        this.skipButton = new JButton();
        this.mapperLabel = new JLabel();
        this.mapperTextField = new JTextField();
        this.messageScrollPane = new JScrollPane();
        this.messageEditorPane = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.titleLabel.setText("Visual Style Builder");
        this.titleLabel.setFont(new Font("SansSerif", 2, 14));
        this.styleNameLabel.setText("New Style Name:");
        this.styleNameTextField.setText(this.VSName);
        this.mapperTextField.setText(this.mapperSuffix);
        this.generateButton.setText("Generate VS");
        this.generateButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                VisualStyleBuilderDialog.this.generateButtonMouseClicked(evt);
            }
        });
        this.skipButton.setText("Skip");
        this.skipButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VisualStyleBuilderDialog.this.skipButtonActionPerformed(evt);
            }
        });
        this.mapperLabel.setText("Mapper Suffix:");
        this.messageEditorPane.setBackground(new Color(244, 244, 244));
        this.messageEditorPane.setEditable(false);
        this.messageEditorPane.setFont(new Font("SansSerif", 1, 12));
        this.messageEditorPane.setText("This function creates new Visual Style based on GML information.  For each node/edge, it will assign individual visual properties, such as node color, shape, border, etc.\n\nNote: for large networks, visual mapper can be slow since this will create visual properties for all objects.\n\n DO NOT USE DOT (.) FOR THESE NAMES.");
        this.messageScrollPane.setViewportView(this.messageEditorPane);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.messageScrollPane).add((Component)this.jSeparator1, -1, 377, Short.MAX_VALUE).add((Component)this.titleLabel, -2, 338, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.mapperLabel, -1, -1, Short.MAX_VALUE).add((Component)this.styleNameLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.mapperTextField, -1, 262, Short.MAX_VALUE).add((Component)this.styleNameTextField, -1, 262, Short.MAX_VALUE))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.generateButton).addPreferredGap(0).add((Component)this.skipButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.titleLabel).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.styleNameLabel).add((Component)this.styleNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.mapperTextField, -2, -1, -2).add((Component)this.mapperLabel)).addPreferredGap(0).add((Component)this.messageScrollPane, -1, 155, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.skipButton).add((Component)this.generateButton)).addContainerGap()));
        this.pack();
    }

    private void generateButtonMouseClicked(MouseEvent evt) {
        boolean validNames = true;
        this.VSName = this.styleNameTextField.getText();
        this.mapperSuffix = this.mapperTextField.getText();
        if (!this.checkDuplicateNames()) {
            try {
                this.gmlReader.applyMaps(this.mapperSuffix, this.VSName);
            }
            catch (DuplicateCalculatorNameException e) {
                JOptionPane.showMessageDialog(this, "The Calculator Name already exists.\nPlease change the suffix.", "Duplicate Name!", 1);
                Cytoscape.getVisualMappingManager().getCalculatorCatalog().removeVisualStyle(this.VSName);
                validNames = false;
            }
            if (validNames) {
                this.dispose();
            }
        } else {
            JOptionPane.showMessageDialog(this, "Error: The Visual Style Name already exists.", "Duplicate Name!", 1);
        }
    }

    private void skipButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private boolean checkDuplicateNames() {
        Set vsNames = Cytoscape.getVisualMappingManager().getCalculatorCatalog().getVisualStyleNames();
        for (String curName : vsNames) {
            if (!curName.equals(this.VSName)) continue;
            return true;
        }
        Cytoscape.getVisualMappingManager().getCalculatorCatalog();
        return false;
    }
}

