/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.writers;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.writers.InteractionWriter;
import cytoscape.giny.CytoscapeRootGraph;
import java.io.IOException;
import java.io.StringWriter;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class InteractionWriterTest
extends TestCase {
    protected CyNetwork net;
    protected int a;
    protected int b;
    protected int c;
    protected int d;
    protected int e;
    protected int ab;
    protected int bc;
    protected int ac;
    protected int bd;

    public void setUp() {
        CytoscapeRootGraph root = Cytoscape.getRootGraph();
        this.a = root.createNode();
        this.b = root.createNode();
        this.c = root.createNode();
        this.d = root.createNode();
        this.e = root.createNode();
        int[] nodes = new int[]{this.a, this.b, this.c, this.d, this.e};
        this.ab = root.createEdge(this.a, this.b, true);
        this.bc = root.createEdge(this.b, this.c, true);
        this.ac = root.createEdge(this.a, this.c, true);
        this.bd = root.createEdge(this.b, this.d, true);
        int[] edges = new int[]{this.ab, this.bc, this.ac, this.bd};
        this.net = Cytoscape.createNetwork(nodes, edges, "graph");
    }

    public void testWrite() {
        try {
            StringWriter writer = new StringWriter();
            InteractionWriter.writeInteractions(this.net, writer);
            String output = writer.toString();
            this.checkSIF(output);
        }
        catch (IOException e) {
            InteractionWriterTest.fail((String)e.getMessage());
        }
    }

    public void testInteractionString() {
        this.checkSIF(InteractionWriter.getInteractionString(this.net));
    }

    protected void checkSIF(String s) {
        String[] lines = s.split(System.getProperty("line.separator"));
        System.out.println("begin sif string");
        System.out.println(s);
        System.out.println("end sif string");
        InteractionWriterTest.assertEquals((String)"number of lines", (int)5, (int)lines.length);
        int edgeLines = 0;
        int nodeLines = 0;
        for (int i = 0; i < lines.length; ++i) {
            if (this.checkLine(lines[i], this.a, this.b)) {
                ++edgeLines;
                continue;
            }
            if (this.checkLine(lines[i], this.b, this.c)) {
                ++edgeLines;
                continue;
            }
            if (this.checkLine(lines[i], this.a, this.c)) {
                ++edgeLines;
                continue;
            }
            if (this.checkLine(lines[i], this.b, this.d)) {
                ++edgeLines;
                continue;
            }
            if (!lines[i].matches("^" + this.e + "$")) continue;
            ++nodeLines;
        }
        InteractionWriterTest.assertEquals((String)"number of edge lines", (int)4, (int)edgeLines);
        InteractionWriterTest.assertEquals((String)"number of node only lines", (int)1, (int)nodeLines);
    }

    protected boolean checkLine(String s, int a, int b) {
        return s.matches("^" + a + "\\s+xx\\s+" + b + "$") || s.matches("^" + b + "\\s+xx\\s+" + a + "$");
    }

    public static void main(String[] args) {
        TestRunner.run(InteractionWriterTest.class);
    }
}

