/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import BiNGO.MonitorableTask;
import BiNGO.SwingWorker;
import giny.model.GraphPerspective;
import giny.model.Node;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NodeDistances
implements MonitorableTask {
    public static final int INFINITY = Integer.MAX_VALUE;
    protected List nodesList;
    protected GraphPerspective perspective;
    protected int[][] distances;
    protected boolean directed;
    protected int currentProgress;
    protected int lengthOfTask;
    protected String statusMessage;
    protected boolean done;
    protected boolean canceled;
    protected HashMap nodeIndexToMatrixIndexMap;

    public NodeDistances(List nodes_list, int[][] distances, GraphPerspective perspective) {
        this(nodes_list, distances, perspective, false);
    }

    public NodeDistances(List nodes_list, int[][] distances, GraphPerspective perspective, boolean directed) {
        this.perspective = perspective;
        this.nodesList = nodes_list;
        this.distances = distances == null ? (Object)new int[this.nodesList.size()][] : distances;
        this.directed = directed;
    }

    public NodeDistances(List nodesList, GraphPerspective perspective, HashMap nodeIndexToMatrixIndexMap) {
        this.nodesList = nodesList;
        this.nodeIndexToMatrixIndexMap = nodeIndexToMatrixIndexMap;
        this.perspective = perspective;
        this.distances = new int[nodesList.size()][];
        this.directed = false;
    }

    public int getCurrentProgress() {
        return this.currentProgress;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getTaskDescription() {
        return "Calculating Node Distances";
    }

    public String getCurrentStatusMessage() {
        return this.statusMessage;
    }

    public boolean isDone() {
        return this.done;
    }

    public void stop() {
        this.canceled = true;
        this.statusMessage = null;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public int[][] calculate() {
        int index;
        Node from_node;
        this.currentProgress = 0;
        this.lengthOfTask = this.distances.length;
        this.done = false;
        this.canceled = false;
        Node[] nodes = new Node[this.nodesList.size()];
        Integer[] integers = new Integer[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            Integer in;
            from_node = (Node)this.nodesList.get(i);
            if (from_node == null) continue;
            index = (Integer)this.nodeIndexToMatrixIndexMap.get(new Integer(from_node.getRootGraphIndex()));
            if (index < 0 || index >= nodes.length) {
                System.err.println("WARNING: GraphNode \"" + from_node + "\" has an index value that is out of range: " + index + ".  Graph indices should be maintained such " + "that no index is unused.");
                return null;
            }
            if (nodes[index] != null) {
                System.err.println("WARNING: GraphNode \"" + from_node + "\" has an index value ( " + index + " ) that is the same as " + "that of another GraphNode ( \"" + nodes[index] + "\" ).  Graph indices should be maintained such " + "that indices are unique.");
                return null;
            }
            nodes[index] = from_node;
            integers[index] = in = new Integer(index);
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        boolean[] completed_nodes = new boolean[nodes.length];
        for (int from_node_index = 0; from_node_index < nodes.length; ++from_node_index) {
            if (this.canceled) {
                this.distances = null;
                return this.distances;
            }
            from_node = nodes[from_node_index];
            if (from_node == null) {
                if (this.distances[from_node_index] == null) {
                    this.distances[from_node_index] = new int[nodes.length];
                }
                Arrays.fill(this.distances[from_node_index], Integer.MAX_VALUE);
                continue;
            }
            if (this.distances[from_node_index] == null) {
                this.distances[from_node_index] = new int[nodes.length];
            }
            Arrays.fill(this.distances[from_node_index], Integer.MAX_VALUE);
            this.distances[from_node_index][from_node_index] = 0;
            Arrays.fill(completed_nodes, false);
            queue.add(integers[from_node_index]);
            while (!queue.isEmpty()) {
                if (this.canceled) {
                    this.distances = null;
                    return this.distances;
                }
                index = (Integer)queue.removeFirst();
                if (completed_nodes[index]) continue;
                completed_nodes[index] = true;
                Node to_node = nodes[index];
                int to_node_distance = this.distances[from_node_index][index];
                if (index < from_node_index) {
                    for (int i = 0; i < nodes.length; ++i) {
                        int distance_through_to_node;
                        if (this.distances[index][i] == Integer.MAX_VALUE || (distance_through_to_node = to_node_distance + this.distances[index][i]) > this.distances[from_node_index][i]) continue;
                        if (this.distances[index][i] == 1) {
                            completed_nodes[i] = true;
                        }
                        this.distances[from_node_index][i] = distance_through_to_node;
                    }
                    continue;
                }
                Iterator neighbors = this.perspective.neighborsList(to_node).iterator();
                while (neighbors.hasNext()) {
                    if (this.canceled) {
                        this.distances = null;
                        return this.distances;
                    }
                    Node neighbor = (Node)neighbors.next();
                    int neighbor_index = (Integer)this.nodeIndexToMatrixIndexMap.get(new Integer(neighbor.getRootGraphIndex()));
                    if (nodes[neighbor_index] == null) {
                        this.distances[from_node_index][neighbor_index] = Integer.MAX_VALUE;
                        continue;
                    }
                    if (completed_nodes[neighbor_index]) continue;
                    int neighbor_distance = this.distances[from_node_index][neighbor_index];
                    if (to_node_distance == Integer.MAX_VALUE || neighbor_distance <= to_node_distance + 1) continue;
                    this.distances[from_node_index][neighbor_index] = to_node_distance + 1;
                    queue.addLast(integers[neighbor_index]);
                }
            }
            ++this.currentProgress;
            double percentDone = this.currentProgress * 100 / this.lengthOfTask;
            this.statusMessage = "Completed " + percentDone + "%.";
        }
        this.done = true;
        this.currentProgress = this.lengthOfTask;
        return this.distances;
    }

    public int[][] getDistances() {
        return this.distances;
    }

    public void start(boolean return_when_done) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return new NodeDistancesTask();
            }
        };
        worker.start();
        if (return_when_done) {
            worker.get();
        }
    }

    class NodeDistancesTask {
        NodeDistancesTask() {
            NodeDistances.this.calculate();
        }
    }
}

