/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.svg;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.ImageSizePanel;
import org.freehep.graphicsio.exportchooser.ImageTypePanel;
import org.freehep.graphicsio.exportchooser.InfoPanel;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.graphicsio.exportchooser.OptionTextField;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import org.freehep.util.UserProperties;

public class SVGExportFileType
extends AbstractExportFileType {
    private static final String[] versionList = new String[]{"Version 1.0 (REC-SVG-20010904)"};
    private OptionCheckBox compress;

    public String getDescription() {
        return "Scalable Vector Graphics";
    }

    public String[] getExtensions() {
        return new String[]{"svgz", "SVGZ", "svg", "SVG"};
    }

    public String[] getMIMETypes() {
        return new String[]{"image/svg+xml"};
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, SVGGraphics2D.getDefaultProperties());
        String rootKey = SVGGraphics2D.class.getName();
        ImageSizePanel imageSize = new ImageSizePanel(options, rootKey);
        OptionPanel format = new OptionPanel("Format");
        format.add("0 * [5 15 5 15] r", new JLabel("SVG Version"));
        format.add("1 * [5 15 5 15] lw", new OptionComboBox(options, SVGGraphics2D.VERSION, versionList));
        this.compress = new OptionCheckBox(options, SVGGraphics2D.COMPRESS, "Compress");
        format.add("0 * * 1 [5 15 5 15] w", this.compress);
        format.add("0 * * 1 [5 15 5 15] w", new OptionCheckBox(options, SVGGraphics2D.STYLABLE, "Stylable"));
        OptionPanel imageExport = new OptionPanel("Embed / Export Images");
        OptionCheckBox exportImages = new OptionCheckBox(options, SVGGraphics2D.EXPORT_IMAGES, "Export");
        imageExport.add("0 * * 1 [5 15 5 15] w", exportImages);
        JLabel exportSuffixLabel = new JLabel("Image Suffix");
        imageExport.add("0 * [5 15 5 15] r", exportSuffixLabel);
        exportImages.enables(exportSuffixLabel);
        OptionTextField exportSuffix = new OptionTextField(options, SVGGraphics2D.EXPORT_SUFFIX, 20);
        imageExport.add("1 * [5 15 5 15] lw", exportSuffix);
        exportImages.enables(exportSuffix);
        InfoPanel infoPanel = new InfoPanel(options, rootKey, new String[]{"Creator", "Title"});
        OptionPanel leftPanel = new OptionPanel();
        leftPanel.add("0 * wt", imageSize);
        leftPanel.add("0 * wt", format);
        leftPanel.add("0 * wh", new JLabel());
        OptionPanel rightPanel = new OptionPanel();
        rightPanel.add("0 * wt", new BackgroundPanel(options, rootKey, true));
        rightPanel.add("0 * wt", imageExport);
        rightPanel.add("0 * wt", new ImageTypePanel(options, rootKey, new String[]{"Smallest Size", "PNG", "JPG"}));
        rightPanel.add("0 * wh", new JLabel());
        OptionPanel panel = new OptionPanel();
        panel.add("0 0 [5 5 5 5] wt", leftPanel);
        panel.add("1 0 [5 5 5 5] wt", rightPanel);
        panel.add("0 1 2 1 [5 5 5 5] wt", infoPanel);
        panel.add("0 * wh", new JLabel());
        return panel;
    }

    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new SVGGraphics2D(os, target);
    }

    public VectorGraphics getGraphics(File file, Component target) throws IOException {
        return new SVGGraphics2D(file, target);
    }

    public File adjustFilename(File file, Properties user) {
        UserProperties options = new UserProperties(user, SVGGraphics2D.getDefaultProperties());
        if (options.isProperty(SVGGraphics2D.COMPRESS)) {
            return SVGExportFileType.adjustExtension(file, "svgz", null);
        }
        return SVGExportFileType.adjustExtension(file, "svg", null);
    }
}

