/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.data.SelectEvent;
import cytoscape.data.SelectEventListener;
import giny.filter.Filter;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.GraphPerspectiveChangeEvent;
import giny.model.GraphPerspectiveChangeListener;
import giny.model.Node;
import giny.model.RootGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectFilter
implements Filter,
GraphPerspectiveChangeListener {
    GraphPerspective graph;
    Set<Node> selectedNodes = new HashSet<Node>();
    Set<Edge> selectedEdges = new HashSet<Edge>();
    List listeners = new ArrayList();

    public SelectFilter(GraphPerspective graph) {
        this.graph = graph;
        graph.addGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
    }

    public Set getSelectedNodes() {
        return this.selectedNodes;
    }

    public Set getSelectedEdges() {
        return this.selectedEdges;
    }

    public boolean isSelected(Node node) {
        return this.selectedNodes.contains(node);
    }

    public boolean isSelected(Edge edge) {
        return this.selectedEdges.contains(edge);
    }

    public boolean passesFilter(Object o) {
        return this.selectedNodes.contains(o) || this.selectedEdges.contains(o);
    }

    public boolean setSelected(Node node, boolean newState) {
        if (newState) {
            if (!this.graph.containsNode(node)) {
                return false;
            }
            boolean setChanged = this.selectedNodes.add(node);
            if (setChanged) {
                this.fireEvent(node, true);
            }
            return setChanged;
        }
        boolean setChanged = this.selectedNodes.remove(node);
        if (setChanged) {
            this.fireEvent(node, false);
        }
        return setChanged;
    }

    public boolean setSelected(Edge edge, boolean newState) {
        if (newState) {
            if (!this.graph.containsEdge(edge)) {
                return false;
            }
            boolean setChanged = this.selectedEdges.add(edge);
            if (setChanged) {
                this.fireEvent(edge, true);
            }
            return setChanged;
        }
        boolean setChanged = this.selectedEdges.remove(edge);
        if (setChanged) {
            this.fireEvent(edge, false);
        }
        return setChanged;
    }

    public Set<Node> setSelectedNodes(Collection<Node> nodesToSet, boolean newState) {
        HashSet<Node> returnSet = new HashSet<Node>();
        if (nodesToSet == null) {
            return returnSet;
        }
        if (newState) {
            for (Node node : nodesToSet) {
                boolean setChanged;
                if (!this.graph.containsNode(node) || !(setChanged = this.selectedNodes.add(node))) continue;
                returnSet.add(node);
            }
            if (returnSet.size() > 0) {
                this.fireEvent(returnSet, true);
            }
        } else {
            for (Node node : nodesToSet) {
                boolean setChanged = this.selectedNodes.remove(node);
                if (!setChanged) continue;
                returnSet.add(node);
            }
            if (returnSet.size() > 0) {
                this.fireEvent(returnSet, false);
            }
        }
        return returnSet;
    }

    public Set<Edge> setSelectedEdges(Collection<Edge> edgesToSet, boolean newState) {
        HashSet<Edge> returnSet = new HashSet<Edge>();
        if (edgesToSet == null) {
            return returnSet;
        }
        if (newState) {
            for (Edge edge : edgesToSet) {
                boolean setChanged;
                if (!this.graph.containsEdge(edge) || !(setChanged = this.selectedEdges.add(edge))) continue;
                returnSet.add(edge);
            }
            if (returnSet.size() > 0) {
                this.fireEvent(returnSet, true);
            }
        } else {
            for (Edge edge : edgesToSet) {
                boolean setChanged = this.selectedEdges.remove(edge);
                if (!setChanged) continue;
                returnSet.add(edge);
            }
            if (returnSet.size() > 0) {
                this.fireEvent(returnSet, false);
            }
        }
        return returnSet;
    }

    public Set selectAllNodes() {
        HashSet<Node> changes = new HashSet<Node>();
        Iterator i = this.graph.nodesIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            boolean setChanged = this.selectedNodes.add(node);
            if (!setChanged) continue;
            changes.add(node);
        }
        if (changes.size() > 0) {
            this.fireEvent(changes, true);
        }
        return changes;
    }

    public Set selectAllEdges() {
        HashSet<Edge> changes = new HashSet<Edge>();
        Iterator i = this.graph.edgesIterator();
        while (i.hasNext()) {
            Edge edge = (Edge)i.next();
            boolean setChanged = this.selectedEdges.add(edge);
            if (!setChanged) continue;
            changes.add(edge);
        }
        if (changes.size() > 0) {
            this.fireEvent(changes, true);
        }
        return changes;
    }

    public Set unselectAllNodes() {
        if (this.selectedNodes.size() == 0) {
            return new HashSet();
        }
        HashSet<Node> changes = new HashSet<Node>(this.selectedNodes);
        this.selectedNodes.clear();
        this.fireEvent(changes, false);
        return changes;
    }

    public Set unselectAllEdges() {
        if (this.selectedEdges.size() == 0) {
            return new HashSet();
        }
        HashSet<Edge> changes = new HashSet<Edge>(this.selectedEdges);
        this.selectedEdges.clear();
        this.fireEvent(changes, false);
        return changes;
    }

    public void graphPerspectiveChanged(GraphPerspectiveChangeEvent event) {
        HashSet<Node> nodeChanges = null;
        if (event.isNodesHiddenType()) {
            Node[] hiddenNodes = event.getHiddenNodes();
            for (int index = 0; index < hiddenNodes.length; ++index) {
                Node node = hiddenNodes[index];
                boolean setChanged = this.selectedNodes.remove(node);
                if (!setChanged) continue;
                if (nodeChanges == null) {
                    nodeChanges = new HashSet<Node>();
                }
                nodeChanges.add(node);
            }
        }
        if (nodeChanges != null && nodeChanges.size() > 0) {
            this.fireEvent(nodeChanges, false);
        }
        HashSet<Edge> edgeChanges = null;
        if (event.isEdgesHiddenType()) {
            Object eventSource = event.getSource();
            RootGraph root = eventSource instanceof RootGraph ? (RootGraph)eventSource : ((GraphPerspective)eventSource).getRootGraph();
            int[] indices = event.getHiddenEdgeIndices();
            for (int index = 0; index < indices.length; ++index) {
                Edge edge = root.getEdge(indices[index]);
                boolean setChanged = this.selectedEdges.remove(edge);
                if (!setChanged) continue;
                if (edgeChanges == null) {
                    edgeChanges = new HashSet<Edge>();
                }
                edgeChanges.add(edge);
            }
        }
        if (edgeChanges != null && edgeChanges.size() > 0) {
            this.fireEvent(edgeChanges, false);
        }
    }

    public void addSelectEventListener(SelectEventListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectEventListener(SelectEventListener listener) {
        this.listeners.remove(listener);
    }

    public List getSelectEventListeners() {
        return this.listeners;
    }

    protected void fireEvent(Object target, boolean selectOn) {
        SelectEvent event = new SelectEvent(this, target, selectOn);
        for (SelectEventListener listener : this.listeners) {
            listener.onSelectEvent(event);
        }
    }
}

