/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.visual.Arrow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.LineType;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.GenericNodeColorCalculator;
import cytoscape.visual.calculators.GenericNodeLabelCalculator;
import cytoscape.visual.calculators.GenericNodeSizeCalculator;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import java.awt.Color;

public class TheVisualStyle {
    private String networkName;
    private double alpha;
    private static String BINGO_VS;
    private static String NODE_TYPE;
    private static String NODE_COLOR;
    private static String NODE_LABEL;
    private static String NODE_SIZE;
    private static String EDGE_TYPE;

    public TheVisualStyle(String networkName, double alpha) {
        this.networkName = networkName;
        this.alpha = alpha;
        BINGO_VS = "BiNGO_" + networkName;
        NODE_TYPE = "nodeType_" + networkName;
        NODE_COLOR = "nodeFillColor_" + networkName;
        NODE_LABEL = "description_" + networkName;
        NODE_SIZE = "nodeSize_" + networkName;
        EDGE_TYPE = "edgeType_" + networkName;
    }

    public VisualStyle createVisualStyle(CyNetwork network) {
        CytoscapeDesktop cytoscapeDesktop = Cytoscape.getDesktop();
        VisualMappingManager vmm = cytoscapeDesktop.getVizMapManager();
        CalculatorCatalog calculatorCatalog = vmm.getCalculatorCatalog();
        VisualStyle currentStyle = vmm.getVisualStyle();
        NodeAppearanceCalculator nodeAppCalc = new NodeAppearanceCalculator(currentStyle.getNodeAppearanceCalculator());
        EdgeAppearanceCalculator edgeAppCalc = new EdgeAppearanceCalculator(currentStyle.getEdgeAppearanceCalculator());
        GlobalAppearanceCalculator globalAppCalc = new GlobalAppearanceCalculator(currentStyle.getGlobalAppearanceCalculator());
        nodeAppCalc.setDefaultNodeShape((byte)8);
        nodeAppCalc.setNodeSizeLocked(true);
        nodeAppCalc.setDefaultNodeFontSize(24.0f);
        edgeAppCalc.setDefaultEdgeTargetArrow(Arrow.BLACK_DELTA);
        edgeAppCalc.setDefaultEdgeSourceArrow(Arrow.NONE);
        edgeAppCalc.setDefaultEdgeLineType(LineType.LINE_2);
        edgeAppCalc.setDefaultEdgeColor(new Color(0, 0, 0));
        globalAppCalc.setDefaultBackgroundColor(new Color(255, 255, 255));
        PassThroughMapping m = new PassThroughMapping((Object)new String(), 1);
        m.setControllingAttributeName(NODE_LABEL, network, false);
        GenericNodeLabelCalculator nlc = new GenericNodeLabelCalculator("Node Description_" + this.networkName, m);
        nodeAppCalc.setNodeLabelCalculator(nlc);
        ContinuousMapping colorMapping = new ContinuousMapping(new Color(255, 0, 0), 1);
        colorMapping.setControllingAttributeName(NODE_COLOR, network, false);
        BoundaryRangeValues colbrVal1 = new BoundaryRangeValues();
        Color nada = new Color(255, 255, 255);
        Color colmin = new Color(255, 255, 0);
        double cols = -(Math.log(this.alpha) / Math.log(10.0));
        colbrVal1.lesserValue = nada;
        colbrVal1.equalValue = colmin;
        colbrVal1.greaterValue = colmin;
        colorMapping.addPoint(cols, colbrVal1);
        BoundaryRangeValues colbrVal2 = new BoundaryRangeValues();
        Color colmax = new Color(255, 127, 0);
        cols = -(Math.log(this.alpha) / Math.log(10.0)) + 5.0;
        colbrVal2.lesserValue = colmax;
        colbrVal2.equalValue = colmax;
        colbrVal2.greaterValue = colmax;
        colorMapping.addPoint(cols, colbrVal2);
        GenericNodeColorCalculator colorCalculator = new GenericNodeColorCalculator("Bingo Node Color_" + this.networkName, colorMapping);
        nodeAppCalc.setNodeFillColorCalculator(colorCalculator);
        ContinuousMapping wMapping = new ContinuousMapping(new Double(50.0), 1);
        wMapping.setControllingAttributeName(NODE_SIZE, network, false);
        ContinuousMapping hMapping = new ContinuousMapping(new Double(50.0), 1);
        hMapping.setControllingAttributeName(NODE_SIZE, network, false);
        for (int j = 0; j <= 1; ++j) {
            BoundaryRangeValues brVals = new BoundaryRangeValues();
            Double size = new Double(380 * j + 20);
            double s = 99 * j + 1;
            brVals.lesserValue = size;
            brVals.equalValue = size;
            brVals.greaterValue = size;
            wMapping.addPoint(s, brVals);
            hMapping.addPoint(s, brVals);
        }
        GenericNodeSizeCalculator nodeSizeCalculator = new GenericNodeSizeCalculator("Bingo Node Width_" + this.networkName, wMapping);
        nodeAppCalc.setNodeWidthCalculator(nodeSizeCalculator);
        GenericNodeSizeCalculator nodeSizeCalculator2 = new GenericNodeSizeCalculator("Bingo Node Height_" + this.networkName, hMapping);
        nodeAppCalc.setNodeHeightCalculator(nodeSizeCalculator2);
        VisualStyle visualStyle = new VisualStyle(BINGO_VS, nodeAppCalc, edgeAppCalc, globalAppCalc);
        return visualStyle;
    }
}

