/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.io.CharacterTokenization;
import org.biojava.bio.seq.io.SymbolListCharSequence;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class UkkonenSuffixTree {
    public static final char DEFAULT_TERM_CHAR = '$';
    private char terminationChar = (char)36;
    SuffixNode root = new SimpleNode();
    public static final int TO_A_LEAF = -1;
    private int e = 0;
    private CharSequence sequences = "";
    private FiniteAlphabet alpha = null;
    private int rule;

    public UkkonenSuffixTree() {
    }

    public UkkonenSuffixTree(String seqs) {
        this();
        this.addSequence(seqs, "unnamed", false);
    }

    public UkkonenSuffixTree(FiniteAlphabet alpha) {
        this();
        this.alpha = alpha;
    }

    public void addSymbolList(SymbolList list, String name, boolean doNotTerminate) throws IllegalSymbolException {
        if (!doNotTerminate) {
            list = new TerminatedSymbolList(list);
        }
        SymbolListCharSequence seq = new SymbolListCharSequence(list);
        System.out.println("Adding symbol list " + ((Object)seq).toString());
        this.addPreppedSequence(seq);
    }

    public void addSequence(String seq, String name, boolean doNotTerminate) {
        ArrayList<String> toBeAdded = new ArrayList<String>();
        if (seq == null || seq.length() == 0) {
            return;
        }
        if (!doNotTerminate && seq.charAt(seq.length() - 1) != this.terminationChar) {
            seq = seq + this.terminationChar;
        }
        int start = 0;
        int i = 0;
        while (seq.indexOf(this.terminationChar, i) != -1) {
            int end = seq.indexOf(this.terminationChar, i);
            toBeAdded.add(seq.substring(start, end + 1));
            i = seq.indexOf(this.terminationChar, i) + 1;
        }
        Iterator iterator = toBeAdded.iterator();
        i = 0;
        while (iterator.hasNext()) {
            String subseq = (String)iterator.next();
            this.addPreppedSequence(subseq);
            ++i;
        }
    }

    private void addPreppedSequence(CharSequence seq) {
        int i;
        int j = 0;
        SuffixNode oldNode = null;
        boolean canLinkJump = false;
        j = i = this.sequences.length();
        this.sequences = ((Object)this.sequences).toString() + ((Object)seq).toString();
        SuffixNode currentNode = this.root;
        while (i < this.sequences.length()) {
            ++this.e;
            while (j <= i) {
                SuffixNode newNode = null;
                while (currentNode != this.root && currentNode.suffixLink == null && canLinkJump) {
                    currentNode = currentNode.parent;
                }
                if (this.root == currentNode) {
                    currentNode = this.jumpTo(this.root, this.sequences, j, i + 1);
                } else {
                    if (canLinkJump) {
                        currentNode = currentNode.suffixLink;
                    }
                    int gammaStart = j + this.getPathLength(currentNode);
                    currentNode = this.jumpTo(currentNode, this.sequences, gammaStart, i + 1);
                }
                if (this.rule == 1) {
                    this.addPositionToLeaf(j, currentNode);
                }
                if (this.rule == 2) {
                    this.doRule2(currentNode, i, j);
                }
                if (this.rule == 3) {
                    currentNode = newNode = this.doRule3(currentNode, i, j);
                }
                if (this.rule == 1 || this.rule == 4 || this.rule == 5) {
                    currentNode = currentNode.parent;
                }
                if (oldNode != null) {
                    if (currentNode.isTerminal()) {
                        currentNode = currentNode.parent;
                    }
                    oldNode.suffixLink = currentNode;
                }
                oldNode = newNode;
                newNode = null;
                if (this.rule == 1 || this.rule == 4 || this.rule == 5) {
                    oldNode = null;
                    canLinkJump = false;
                    break;
                }
                canLinkJump = true;
                ++j;
            }
            ++i;
        }
        this.finishAddition();
    }

    public SuffixNode walkTo(SuffixNode starting, String source, int from, int to) {
        SuffixNode currentNode = starting;
        SuffixNode arrivedAt = starting;
        while (from < to) {
            arrivedAt = (SuffixNode)currentNode.children.get(new Character(source.charAt(from)));
            if (arrivedAt == null) {
                from = to;
                arrivedAt = currentNode;
                this.rule = 2;
                break;
            }
            CharSequence edgeLabel = this.getEdgeLabel(arrivedAt);
            if (edgeLabel.length() >= to - from) {
                if (edgeLabel.equals(source.substring(from, to))) {
                    this.rule = arrivedAt.isTerminal() ? 1 : 5;
                }
                this.rule = edgeLabel.subSequence(0, to - from).equals(source.substring(from, to)) ? 4 : 3;
                from = to;
                continue;
            }
            if (source.subSequence(from, from + edgeLabel.length()).equals(edgeLabel)) {
                from += edgeLabel.length();
                currentNode = arrivedAt;
                continue;
            }
            this.rule = 3;
            from = to;
        }
        return arrivedAt;
    }

    public SuffixNode jumpTo(SuffixNode starting, CharSequence source, int from, int to) {
        boolean canGoDown = true;
        int original = from;
        SuffixNode originalNode = starting;
        boolean i = false;
        SuffixNode currentNode = starting;
        SuffixNode arrivedAt = starting;
        this.rule = 0;
        if (from == to) {
            this.rule = 5;
            return starting;
        }
        while (canGoDown) {
            if (currentNode.isTerminal()) {
                System.out.println("ARRGH! at " + source.subSequence(original, to) + "(" + from + "," + original + "," + to + ") from " + this.getLabel(originalNode));
            }
            if ((arrivedAt = (SuffixNode)currentNode.children.get(new Character(source.charAt(from)))) == null) {
                canGoDown = false;
                arrivedAt = currentNode;
                this.rule = 2;
                break;
            }
            int edgeLength = this.getEdgeLength(arrivedAt);
            if (edgeLength >= to - from) {
                int before = currentNode.labelEnd + to - from + 1;
                int after = this.getPathEnd(arrivedAt) - this.getEdgeLength(arrivedAt) + to - from - 1;
                this.rule = this.sequences.charAt(after) == source.charAt(to - 1) ? (this.getEdgeLength(arrivedAt) == to - from ? (arrivedAt.isTerminal() ? 1 : 5) : 4) : 3;
                canGoDown = false;
                break;
            }
            from += edgeLength;
            currentNode = arrivedAt;
        }
        return arrivedAt;
    }

    protected int getEdgeLength(SuffixNode child) {
        if (child == this.root) {
            return 0;
        }
        SuffixNode parent = child.parent;
        int parentLength = this.getPathLength(parent);
        int childLength = this.getPathLength(child);
        if (childLength - parentLength <= 0) {
            System.out.println("negative length " + (childLength - parentLength));
            System.out.println(this.getLabel(child) + "," + this.getLabel(parent));
        }
        return childLength - parentLength;
    }

    protected CharSequence getEdgeLabel(SuffixNode child) {
        return this.sequences.subSequence(child.labelStart + (this.getPathLength(child) - this.getEdgeLength(child)), child.labelEnd == -1 ? this.e : child.labelEnd);
    }

    protected int getPathLength(SuffixNode node) {
        return this.getPathEnd(node) - node.labelStart;
    }

    protected int getPathEnd(SuffixNode node) {
        return node.labelEnd == -1 ? this.e : node.labelEnd;
    }

    protected CharSequence getLabel(SuffixNode node) {
        if (node == this.root) {
            return "root";
        }
        return ((Object)this.sequences.subSequence(node.labelStart, node.labelEnd == -1 ? this.e : node.labelEnd)).toString();
    }

    protected ArrayList getAllNodes(SuffixNode root, ArrayList list, boolean leavesOnly) {
        if (list == null) {
            list = new ArrayList();
        }
        if (!leavesOnly || leavesOnly && root.isTerminal()) {
            list.add(root);
        }
        if (!root.isTerminal()) {
            Iterator iterator = root.children.values().iterator();
            while (iterator.hasNext()) {
                list = this.getAllNodes((SuffixNode)iterator.next(), list, leavesOnly);
            }
        }
        return list;
    }

    public void printTree() {
        ArrayList allNodes = this.getAllNodes(this.root, null, false);
        for (int i = 0; i < allNodes.size(); ++i) {
            SuffixNode node = (SuffixNode)allNodes.get(i);
            if (node == this.root) {
                System.out.println("root");
                continue;
            }
            System.out.println("node " + i + " label " + this.getLabel(node) + " attached to " + this.getLabel(node.parent));
        }
    }

    public SuffixNode getRoot() {
        return this.root;
    }

    private void addPositionToLeaf(int pos, SuffixNode leaf) {
        if (leaf.additionalLabels == null) {
            leaf.additionalLabels = new int[]{pos};
        } else {
            int[] moreLabels = new int[leaf.additionalLabels.length + 1];
            System.arraycopy(leaf.additionalLabels, 0, moreLabels, 0, leaf.additionalLabels.length);
            moreLabels[moreLabels.length - 1] = pos;
            leaf.additionalLabels = moreLabels;
        }
    }

    private void doRule2(SuffixNode parent, int splittingPos, int suffixStart) {
        SimpleNode leaf = new SimpleNode(parent, suffixStart);
        parent.children.put(new Character(this.sequences.charAt(splittingPos)), leaf);
    }

    private SuffixNode doRule3(SuffixNode child, int splittingPos, int suffixStart) {
        SuffixNode parent = child.parent;
        SimpleNode middle = new SimpleNode(parent, suffixStart, splittingPos);
        Character x = new Character(this.sequences.charAt(child.labelStart + this.getPathLength(child) - this.getEdgeLength(child)));
        Character y = new Character(this.sequences.charAt(child.labelStart + this.getPathLength(child) - this.getEdgeLength(child) + this.getEdgeLength(middle)));
        parent.children.remove(x);
        parent.children.put(x, middle);
        middle.children.put(y, child);
        child.parent = middle;
        this.doRule2(middle, splittingPos, suffixStart);
        return middle;
    }

    private void finishAddition() {
        ArrayList leaves = this.getAllNodes(this.root, null, true);
        for (int i = 0; i < leaves.size(); ++i) {
            SuffixNode leaf = (SuffixNode)leaves.get(i);
            if (leaf.labelEnd != -1) continue;
            leaf.labelEnd = this.e;
        }
    }

    private void checkParent(SuffixNode child) {
        SuffixNode parent = child.parent;
        CharSequence parentLabel = this.getLabel(parent);
        CharSequence label = this.getLabel(child);
        if (parentLabel.equals("root")) {
            parentLabel = "";
        }
        if (parentLabel.length() >= label.length() || !parentLabel.equals(label.subSequence(0, parentLabel.length()))) {
            System.err.println("bad addition on rule " + this.rule);
            System.err.println(parentLabel + " against " + label);
            System.err.println("child (" + child.labelStart + "," + (child.labelEnd == -1 ? this.e : child.labelEnd) + ")");
            System.err.println("parent (" + parent.labelStart + "," + parent.labelEnd + ")");
        }
    }

    public boolean subStringExists(String str) {
        this.walkTo(this.root, str, 0, str.length());
        return this.rule == 1 || this.rule == 4 || this.rule == 5;
    }

    private class TerminatedSymbolList
    implements SymbolList {
        private SymbolList unterminated;
        final Symbol TERMINATION_SYMBOL;
        private AbstractAlphabet alpha;
        private Map translationTable = new HashMap();

        public TerminatedSymbolList(SymbolList unterminated) {
            SymbolTokenization sToke;
            this.unterminated = unterminated;
            this.TERMINATION_SYMBOL = AlphabetManager.createSymbol("Termination");
            FiniteAlphabet oldAlphabet = (FiniteAlphabet)unterminated.getAlphabet();
            HashSet set = new HashSet();
            Iterator i = oldAlphabet.iterator();
            while (i.hasNext()) {
                set.add(i.next());
            }
            set.add(this.TERMINATION_SYMBOL);
            this.alpha = new SimpleAlphabet(set);
            CharacterTokenization tokenizer = new CharacterTokenization(this.alpha, true);
            tokenizer.bindSymbol(this.TERMINATION_SYMBOL, '$');
            try {
                sToke = oldAlphabet.getTokenization("token");
            }
            catch (BioException be) {
                throw new BioError("Internal error: failed to get SymbolTokenization for SymbolList alphabet", be);
            }
            if (sToke.getTokenType() != SymbolTokenization.CHARACTER) {
                throw new IllegalArgumentException("Only FiniteAlphabets using a char token are supported by UkkonenSuffixTree");
            }
            try {
                Iterator i2 = AlphabetManager.getAllSymbols(oldAlphabet).iterator();
                while (i2.hasNext()) {
                    Symbol newSymbol;
                    Symbol oldSymbol = (Symbol)i2.next();
                    if (oldSymbol instanceof AtomicSymbol) {
                        newSymbol = oldSymbol;
                    } else {
                        HashSet s = new HashSet();
                        Iterator si = ((FiniteAlphabet)oldSymbol.getMatches()).iterator();
                        while (si.hasNext()) {
                            s.add(si.next());
                        }
                        newSymbol = this.alpha.getAmbiguity(s);
                    }
                    char c = sToke.tokenizeSymbol(oldSymbol).charAt(0);
                    tokenizer.bindSymbol(newSymbol, c);
                    this.translationTable.put(oldSymbol, newSymbol);
                }
                i2 = AlphabetManager.getAllSymbols(this.alpha).iterator();
                while (i2.hasNext()) {
                    Symbol s = (Symbol)i2.next();
                    Alphabet mathes = s.getMatches();
                    if (!mathes.contains(this.TERMINATION_SYMBOL)) continue;
                    tokenizer.bindSymbol(s, '$');
                }
            }
            catch (IllegalSymbolException ise) {
                throw new AssertionFailure("Assertion Failure: This alphabet has been custom made so this doesn't happen", ise);
            }
            this.alpha.putTokenization("token", tokenizer);
        }

        public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
            this.unterminated.addChangeListener(changeListener, changeType);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.unterminated.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
            this.unterminated.removeChangeListener(changeListener, changeType);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.unterminated.removeChangeListener(changeListener);
        }

        public boolean isUnchanging(ChangeType changeType) {
            return this.unterminated.isUnchanging(changeType);
        }

        public int length() {
            return this.unterminated.length() + 1;
        }

        public Iterator iterator() {
            return this.unterminated.iterator();
        }

        public SymbolList subList(int n, int n1) throws IndexOutOfBoundsException {
            if (n1 != this.unterminated.length() + 1) {
                return this.unterminated.subList(n, n1);
            }
            List list = this.unterminated.subList(n, n1 - 1).toList();
            list.add(this.TERMINATION_SYMBOL);
            try {
                return new SimpleSymbolList(this.getAlphabet(), list);
            }
            catch (IllegalSymbolException e) {
                throw new AssertionFailure("Assertion Failure: This alphabet was created just so it doesn't do this", e);
            }
        }

        public Alphabet getAlphabet() {
            return this.alpha;
        }

        public Symbol symbolAt(int n) throws IndexOutOfBoundsException {
            if (n != this.length()) {
                return (Symbol)this.translationTable.get(this.unterminated.symbolAt(n));
            }
            return this.TERMINATION_SYMBOL;
        }

        public List toList() {
            List answer = this.unterminated.toList();
            answer.add(this.TERMINATION_SYMBOL);
            return answer;
        }

        public String seqString() {
            try {
                SymbolTokenization toke = this.getAlphabet().getTokenization("token");
                return this.unterminated.seqString() + toke.tokenizeSymbol(this.TERMINATION_SYMBOL);
            }
            catch (BioException ex) {
                throw new BioRuntimeException("Couldn't tokenize sequence", ex);
            }
        }

        public String subStr(int n, int n1) throws IndexOutOfBoundsException {
            return this.subList(n, n1).seqString();
        }

        public void edit(Edit edit) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException {
            throw new ChangeVetoException("TerminatedSymbolList is immutable");
        }
    }

    class SimpleNode
    extends SuffixNode {
        public SimpleNode() {
            this.parent = null;
            this.suffixLink = null;
            this.labelStart = 0;
            this.labelEnd = 0;
            this.children = new HashMap();
            this.additionalLabels = null;
        }

        public SimpleNode(SuffixNode parent, int position) {
            this();
            this.parent = parent;
            this.labelStart = position;
            this.labelEnd = -1;
            this.children = null;
        }

        public SimpleNode(SuffixNode parent, int labelStart, int labelStop) {
            this();
            this.parent = parent;
            this.labelStart = labelStart;
            this.labelEnd = labelStop;
        }

        public boolean isTerminal() {
            return this.children == null;
        }

        public boolean hasChild(Character x) {
            return this.getChild(x) != null;
        }

        public SuffixNode getChild(Character x) {
            return this.children == null ? null : (SuffixNode)this.children.get(x);
        }

        public SuffixNode getParent() {
            return this.parent;
        }
    }

    public static abstract class SuffixNode {
        static final int A_LEAF = -1;
        SuffixNode parent;
        SuffixNode suffixLink;
        int labelStart;
        int labelEnd;
        HashMap children;
        int[] additionalLabels;

        public abstract boolean isTerminal();

        public abstract boolean hasChild(Character var1);

        abstract SuffixNode getChild(Character var1);

        abstract SuffixNode getParent();
    }
}

