/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.symbol.AbstractLocationDecorator;
import org.biojava.bio.symbol.BetweenLocationTools;
import org.biojava.bio.symbol.CircularLocation;
import org.biojava.bio.symbol.CircularLocationTools;
import org.biojava.bio.symbol.CompoundLocation;
import org.biojava.bio.symbol.EmptyLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.MergeLocation;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;

public final class LocationTools {
    private LocationTools() {
    }

    public static Location union(Location locA, Location locB) {
        if (LocationTools.isDecorated(locA) || LocationTools.isDecorated(locB)) {
            LocationTools.handleDecorations(locA, locB);
            if (locA instanceof CircularLocation && locB instanceof CircularLocation) {
                return CircularLocationTools.union((CircularLocation)locA, (CircularLocation)locB);
            }
            if (BetweenLocationTools.isBetween(locA) || BetweenLocationTools.isBetween(locB)) {
                return BetweenLocationTools.union(locA, locB);
            }
        }
        if (locA.isContiguous() && locB.isContiguous() && locA.overlaps(locB)) {
            MergeLocation mloc = null;
            try {
                mloc = MergeLocation.mergeLocations(locA, locB);
            }
            catch (BioException ex) {
                throw new BioError("Assertion Error, cannot build MergeLocation", ex);
            }
            return mloc;
        }
        ArrayList locList = new ArrayList();
        Iterator i = locA.blockIterator();
        while (i.hasNext()) {
            locList.add(i.next());
        }
        i = locB.blockIterator();
        while (i.hasNext()) {
            locList.add(i.next());
        }
        return LocationTools._union(locList);
    }

    public static Location intersection(Location locA, Location locB) {
        if (LocationTools.isDecorated(locA) || LocationTools.isDecorated(locB)) {
            LocationTools.handleDecorations(locA, locB);
            if (BetweenLocationTools.isBetween(locA) || BetweenLocationTools.isBetween(locB)) {
                return BetweenLocationTools.intersection(locA, locB);
            }
            if (CircularLocationTools.isCircular(locA) || CircularLocationTools.isCircular(locB)) {
                return CircularLocationTools.intersection(locA, locB);
            }
        }
        if (locA.isContiguous() && locB.isContiguous()) {
            if (LocationTools.contains(locA, locB)) {
                return locB;
            }
            if (LocationTools.contains(locB, locA)) {
                return locA;
            }
            if (LocationTools.overlaps(locA, locB)) {
                int min = Math.max(locA.getMin(), locB.getMin());
                int max = Math.min(locA.getMax(), locB.getMax());
                return LocationTools.makeLocation(min, max);
            }
            return Location.empty;
        }
        ArrayList<Location> locList = new ArrayList<Location>();
        List blA = LocationTools.getBlockList(locA);
        int minBlock = LocationTools.blockContainingOrFollowingPoint(blA, locB.getMin());
        int maxBlock = LocationTools.blockContainingOrPreceedingPoint(blA, locB.getMax());
        if (minBlock == -1 || maxBlock == -1) {
            return Location.empty;
        }
        blA = blA.subList(minBlock, maxBlock + 1);
        List blB = LocationTools.getBlockList(locB);
        int minBlock2 = LocationTools.blockContainingOrFollowingPoint(blB, locA.getMin());
        int maxBlock2 = LocationTools.blockContainingOrPreceedingPoint(blB, locA.getMax());
        if (minBlock2 == -1 || maxBlock2 == -1) {
            return Location.empty;
        }
        blB = blB.subList(minBlock2, maxBlock2 + 1);
        if (blA.size() > blB.size()) {
            List temp = blA;
            blA = blB;
            blB = temp;
        }
        Iterator i = blA.iterator();
        while (i.hasNext()) {
            Location blocA = (Location)i.next();
            int minHitIndex = LocationTools.blockContainingOrFollowingPoint(blB, blocA.getMin());
            int maxHitIndex = LocationTools.blockContainingOrPreceedingPoint(blB, blocA.getMax());
            for (int hitIndex = minHitIndex; hitIndex <= maxHitIndex; ++hitIndex) {
                Location blocB = (Location)blB.get(hitIndex);
                locList.add(LocationTools.intersection(blocA, blocB));
            }
        }
        return LocationTools.buildLoc(locList);
    }

    private static List getBlockList(Location l) {
        if (l == Location.empty) {
            return Collections.EMPTY_LIST;
        }
        if (l instanceof CompoundLocation) {
            return ((CompoundLocation)l).getBlockList();
        }
        if (l.isContiguous() && !CircularLocationTools.isCircular(l)) {
            return Collections.nCopies(1, l);
        }
        ArrayList bl = new ArrayList();
        Iterator bi = l.blockIterator();
        while (bi.hasNext()) {
            bl.add(bi.next());
        }
        Collections.sort(bl, Location.naturalOrder);
        return bl;
    }

    private static int blockContainingPoint(List bl, int point) {
        int start = 0;
        int end = bl.size() - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            Location block = (Location)bl.get(mid);
            if (block.contains(point)) {
                return mid;
            }
            if (point < block.getMin()) {
                end = mid - 1;
                continue;
            }
            if (point > block.getMax()) {
                start = mid + 1;
                continue;
            }
            throw new BioError("Assertion failed: overrun in binary search");
        }
        return -1;
    }

    private static int blockContainingOrPreceedingPoint(List bl, int point) {
        int start = 0;
        int length = bl.size();
        int end = length - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            Location block = (Location)bl.get(mid);
            if (block.contains(point)) {
                return mid;
            }
            if (point < block.getMin()) {
                end = mid - 1;
                continue;
            }
            if (point > block.getMax()) {
                start = mid + 1;
                continue;
            }
            throw new BioError("Assertion failed: overrun in binary search");
        }
        if (end < length) {
            return end;
        }
        return -1;
    }

    private static int blockContainingOrFollowingPoint(List bl, int point) {
        int start = 0;
        int length = bl.size();
        int end = length - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            Location block = (Location)bl.get(mid);
            if (block.contains(point)) {
                return mid;
            }
            if (point < block.getMin()) {
                end = mid - 1;
                continue;
            }
            if (point > block.getMax()) {
                start = mid + 1;
                continue;
            }
            throw new BioError("Assertion failed: overrun in binary search");
        }
        if (start >= 0) {
            return start;
        }
        return -1;
    }

    public static boolean canMerge(Location locA, Location locB) {
        return LocationTools.overlaps(locA, locB) || LocationTools.overlaps(locA.translate(1), locB) || LocationTools.overlaps(locA.translate(-1), locB);
    }

    public static boolean overlaps(Location locA, Location locB) {
        if (LocationTools.isDecorated(locA) || LocationTools.isDecorated(locB)) {
            LocationTools.handleDecorations(locA, locB);
            if (BetweenLocationTools.isBetween(locA) || BetweenLocationTools.isBetween(locB)) {
                return BetweenLocationTools.overlaps(locA, locB);
            }
        }
        if (locA.isContiguous() && locB.isContiguous()) {
            return locA.getMax() >= locB.getMin() && locA.getMin() <= locB.getMax();
        }
        List blA = LocationTools.getBlockList(locA);
        int minBlock = LocationTools.blockContainingOrFollowingPoint(blA, locB.getMin());
        int maxBlock = LocationTools.blockContainingOrPreceedingPoint(blA, locB.getMax());
        if (minBlock == -1 || maxBlock == -1) {
            return false;
        }
        blA = blA.subList(minBlock, maxBlock + 1);
        List blB = LocationTools.getBlockList(locB);
        int minBlock2 = LocationTools.blockContainingOrFollowingPoint(blB, locA.getMin());
        int maxBlock2 = LocationTools.blockContainingOrPreceedingPoint(blB, locA.getMax());
        if (minBlock2 == -1 || maxBlock2 == -1) {
            return false;
        }
        blB = blB.subList(minBlock2, maxBlock2 + 1);
        Iterator aI = blA.iterator();
        while (aI.hasNext()) {
            Location a = (Location)aI.next();
            Iterator bI = blB.iterator();
            while (bI.hasNext()) {
                Location b = (Location)bI.next();
                if (!LocationTools.overlaps(a, b)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Location locA, Location locB) {
        if (LocationTools.isDecorated(locA) || LocationTools.isDecorated(locB)) {
            LocationTools.handleDecorations(locA, locB);
            if (BetweenLocationTools.isBetween(locA) || BetweenLocationTools.isBetween(locB)) {
                return BetweenLocationTools.contains(locA, locB);
            }
        }
        if (locA.getMin() <= locB.getMin() && locA.getMax() >= locB.getMax()) {
            if (locA.isContiguous()) {
                return true;
            }
            List blA = LocationTools.getBlockList(locA);
            Iterator biB = locB.blockIterator();
            while (biB.hasNext()) {
                Location bloc = (Location)biB.next();
                int hitIndex = LocationTools.blockContainingPoint(blA, bloc.getMin());
                if (hitIndex < 0) {
                    return false;
                }
                Location hitBloc = (Location)blA.get(hitIndex);
                if (bloc.getMax() <= hitBloc.getMax()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean areEqual(Location locA, Location locB) {
        if (LocationTools.isDecorated(locA) || LocationTools.isDecorated(locB)) {
            LocationTools.handleDecorations(locA, locB);
            if (BetweenLocationTools.isBetween(locA) || BetweenLocationTools.isBetween(locB)) {
                return BetweenLocationTools.areEqual(locA, locB);
            }
        }
        if (locA.isContiguous() != locB.isContiguous()) {
            return false;
        }
        if (locA.isContiguous()) {
            return locA.getMin() == locB.getMin() && locA.getMax() == locB.getMax();
        }
        Iterator i1 = locA.blockIterator();
        Iterator i2 = locB.blockIterator();
        while (i1.hasNext() && i2.hasNext()) {
            Location l1 = (Location)i1.next();
            Location l2 = (Location)i2.next();
            if (l1.getMin() == l2.getMin() && l1.getMax() == l2.getMax()) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    static Location buildLoc(List locList) {
        if (locList.size() == 0) {
            return Location.empty;
        }
        if (locList.size() == 1) {
            return (Location)locList.get(0);
        }
        Collections.sort(locList, Location.naturalOrder);
        return new CompoundLocation(locList);
    }

    static Location buildLocSorted(List locList) {
        if (locList.size() == 0) {
            return Location.empty;
        }
        if (locList.size() == 1) {
            return (Location)locList.get(0);
        }
        return new CompoundLocation(locList);
    }

    public static Location union(Collection locs) {
        Location loc;
        boolean circular = false;
        ArrayList<Location> locList = new ArrayList<Location>();
        Iterator li = locs.iterator();
        while (li.hasNext()) {
            loc = (Location)li.next();
            if (loc instanceof CircularLocation) {
                circular = true;
                locList.add(loc);
                continue;
            }
            Iterator bi = loc.blockIterator();
            while (bi.hasNext()) {
                locList.add((Location)bi.next());
            }
        }
        if (circular) {
            li = locList.listIterator();
            loc = (CircularLocation)li.next();
            while (li.hasNext()) {
                loc = (CircularLocation)LocationTools.union(loc, (Location)li.next());
            }
            return loc;
        }
        return LocationTools._union(locList);
    }

    static Location _union(List locList) {
        Collections.sort(locList, Location.naturalOrder);
        ArrayList<Location> joinList = new ArrayList<Location>();
        Iterator i = locList.iterator();
        Location last = Location.empty;
        if (i.hasNext()) {
            last = (Location)i.next();
        }
        while (i.hasNext()) {
            Location cur = (Location)i.next();
            if (LocationTools.canMerge(last, cur)) {
                try {
                    last = MergeLocation.mergeLocations(last, cur);
                    continue;
                }
                catch (BioException ex) {
                    throw new BioError("Cannot make MergeLocation", ex);
                }
            }
            joinList.add(last);
            last = cur;
        }
        if (last == Location.empty) {
            return Location.empty;
        }
        joinList.add(last);
        return LocationTools.buildLocSorted(joinList);
    }

    public static Location makeLocation(int min, int max) {
        if (min == max) {
            return new PointLocation(min);
        }
        return new RangeLocation(min, max);
    }

    public static CircularLocation makeCircularLocation(int min, int max, int seqLength) {
        return CircularLocationTools.makeCircLoc(min, max, seqLength);
    }

    static boolean isDecorated(Location theLocation) {
        return theLocation instanceof AbstractLocationDecorator;
    }

    private static void handleDecorations(Location locA, Location locB) {
        if (CircularLocationTools.isCircular(locA) || CircularLocationTools.isCircular(locB)) {
            if (!CircularLocationTools.safeOperation(locA, locB)) {
                throw new UnsupportedOperationException("Binary operations between Circular and Non-Circular locations, or CircularLocations from sequences of differing length are currently unsupported.");
            }
        } else if (!BetweenLocationTools.isBetween(locA) && !BetweenLocationTools.isBetween(locB)) {
            throw new ClassCastException("Decorated locations are not handled in this version: " + locA.getClass().getName() + ", " + locB.getClass().getName());
        }
    }

    public static Location flip(Location loc, int len) {
        if (loc instanceof PointLocation) {
            return new PointLocation(len - loc.getMin() + 1);
        }
        if (loc instanceof RangeLocation) {
            return new RangeLocation(len - loc.getMax() + 1, len - loc.getMin() + 1);
        }
        Iterator bi = loc.blockIterator();
        Location res = (Location)bi.next();
        while (bi.hasNext()) {
            res = LocationTools.union(res, (Location)bi.next());
        }
        return res;
    }

    public static Location subtract(Location keep, Location remove) {
        Location x = keep;
        Location y = remove;
        if (LocationTools.isDecorated(x) || LocationTools.isDecorated(y)) {
            LocationTools.handleDecorations(x, y);
        }
        ArrayList<RangeLocation> spans = new ArrayList<RangeLocation>();
        Iterator i = x.blockIterator();
        while (i.hasNext()) {
            Location xb = (Location)i.next();
            Location yb = LocationTools.intersection(xb, y);
            int pos = xb.getMin();
            Iterator j = yb.blockIterator();
            while (j.hasNext()) {
                Location sb = (Location)j.next();
                if (sb.getMin() > pos) {
                    spans.add(new RangeLocation(pos, sb.getMin() - 1));
                }
                pos = sb.getMax() + 1;
            }
            if (pos > xb.getMax()) continue;
            spans.add(new RangeLocation(pos, xb.getMax()));
        }
        return LocationTools.union(spans);
    }

    public static int coverage(Location loc) {
        int cov = 0;
        Iterator i = loc.blockIterator();
        while (i.hasNext()) {
            Location bloc = (Location)i.next();
            cov += bloc.getMax() - bloc.getMin() + 1;
        }
        return cov;
    }

    public static Location shadow(Location loc) {
        if (loc.isContiguous()) {
            return loc;
        }
        return new RangeLocation(loc.getMin(), loc.getMax());
    }

    public static int blockCount(Location loc) {
        if (loc.isContiguous()) {
            if (loc instanceof EmptyLocation) {
                return 0;
            }
            return 1;
        }
        int cnt = 0;
        Iterator bi = loc.blockIterator();
        while (bi.hasNext()) {
            bi.next();
            ++cnt;
        }
        return cnt;
    }
}

