/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssaha;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.biojava.bio.BioError;
import org.biojava.bio.program.ssaha.DataStore;
import org.biojava.bio.program.ssaha.SearchListener;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Packing;
import org.biojava.bio.symbol.SymbolList;

public class CompactedDataStore
implements DataStore {
    private final Packing packing;
    private final int wordLength;
    private final IntBuffer hashTable;
    private final MappedByteBuffer hitTable;
    private final IntBuffer nameArray;
    private final MappedByteBuffer nameTable;
    private final int numSequences;

    CompactedDataStore(File dataStoreFile) throws IOException {
        FileChannel channel = new FileInputStream(dataStoreFile).getChannel();
        MappedByteBuffer rootBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, 24L);
        rootBuffer.position(0);
        int hashTablePos = rootBuffer.getInt();
        int hitTablePos = rootBuffer.getInt();
        int nameArrayPos = rootBuffer.getInt();
        int nameTablePos = rootBuffer.getInt();
        this.wordLength = rootBuffer.getInt();
        int packingStreamLength = rootBuffer.getInt();
        rootBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, 24 + packingStreamLength);
        rootBuffer.position(24);
        byte[] packingBuffer = new byte[packingStreamLength];
        rootBuffer.get(packingBuffer);
        ByteArrayInputStream packingStream = new ByteArrayInputStream(packingBuffer);
        ObjectInputStream packingSerializer = new ObjectInputStream(packingStream);
        try {
            this.packing = (Packing)packingSerializer.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new Error("Can't restore packing", cnfe);
        }
        MappedByteBuffer hashTable_MB = channel.map(FileChannel.MapMode.READ_ONLY, hashTablePos, 4L);
        hashTable_MB.position(0);
        int hashTableSize = hashTable_MB.getInt();
        this.hashTable = channel.map(FileChannel.MapMode.READ_ONLY, hashTablePos + 4, hashTableSize - 4).asIntBuffer();
        MappedByteBuffer hitTable_MB = channel.map(FileChannel.MapMode.READ_ONLY, hitTablePos, 4L);
        hitTable_MB.position(0);
        int hitTableSize = hitTable_MB.getInt();
        this.hitTable = channel.map(FileChannel.MapMode.READ_ONLY, hitTablePos + 4, hitTableSize - 4);
        MappedByteBuffer nameArray_MB = channel.map(FileChannel.MapMode.READ_ONLY, nameArrayPos, 4L);
        nameArray_MB.position(0);
        int nameArraySize = nameArray_MB.getInt();
        this.numSequences = nameArraySize / 8;
        this.nameArray = channel.map(FileChannel.MapMode.READ_ONLY, nameArrayPos + 4, nameArraySize - 4).asIntBuffer();
        MappedByteBuffer nameTable_MB = channel.map(FileChannel.MapMode.READ_ONLY, nameTablePos, 4L);
        nameTable_MB.position(0);
        int nameTableSize = nameTable_MB.getInt();
        this.nameTable = channel.map(FileChannel.MapMode.READ_ONLY, nameTablePos + 4, nameTableSize - 4);
    }

    public FiniteAlphabet getAlphabet() {
        return this.packing.getAlphabet();
    }

    public void search(String seqID, SymbolList symList, SearchListener listener) {
        try {
            int word = 0;
            int lengthFromUnknown = 0;
            listener.startSearch(seqID);
            for (int pos = 1; pos <= symList.length(); ++pos) {
                word >>= this.packing.wordSize();
                byte p = this.packing.pack(symList.symbolAt(pos));
                if (p < 0) {
                    lengthFromUnknown = 0;
                } else {
                    ++lengthFromUnknown;
                    word |= p << (this.wordLength - 1) * this.packing.wordSize();
                }
                if (lengthFromUnknown < this.wordLength) continue;
                this.fireHits(word, pos - this.wordLength + 1, listener);
            }
            listener.endSearch(seqID);
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Assertion Failure: Symbol dissapeared");
        }
    }

    public String seqNameForID(int id) {
        int offset = this.nameArray.get(id);
        this.nameTable.position(offset);
        int length = this.nameTable.getInt();
        StringBuffer sbuff = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            sbuff.append(this.nameTable.getChar());
        }
        return sbuff.toString();
    }

    private int seqIDForPos(int pos) {
        int endOffset;
        int offset;
        int mid;
        if (this.numSequences == 1) {
            return 0;
        }
        int maxBound = this.numSequences - 1;
        int minBound = 0;
        while (true) {
            mid = (minBound + maxBound) / 2;
            offset = this.nameArray.get(mid * 2 + 1);
            endOffset = Integer.MAX_VALUE;
            if (mid < this.numSequences - 1) {
                endOffset = this.nameArray.get(mid * 2 + 3);
            }
            if (pos > offset && pos < endOffset) {
                return mid * 2;
            }
            if (pos < offset) {
                maxBound = mid - 1;
                continue;
            }
            if (pos <= endOffset) break;
            minBound = mid + 1;
        }
        throw new Error("Ooops: could not locate seq name for \tpos: " + pos + "\tmid: " + mid + "\toffset: " + offset + "\tendOffset: " + endOffset + "\tminBound: " + minBound + "\tmaxBound: " + maxBound);
    }

    private int offsetForID(int id) {
        if (this.numSequences == 1) {
            return 0;
        }
        return this.nameArray.get(id + 1);
    }

    public void fireHits(int word, int offset, SearchListener listener) {
        int hitOffset = this.hashTable.get(word);
        if (hitOffset >= 0) {
            try {
                this.hitTable.position(hitOffset);
            }
            catch (IllegalArgumentException e) {
                System.out.println("word:\t" + word);
                System.out.println("offset:\t" + offset);
                System.out.println("hitOffset\t" + hitOffset);
                throw e;
            }
            int hits = this.hitTable.getInt();
            for (int i = 0; i < hits; ++i) {
                int pos = this.hitTable.getInt();
                int id = this.seqIDForPos(pos);
                listener.hit(id, offset, pos - this.offsetForID(id), this.wordLength);
            }
        } else if (hitOffset == -2) {
            System.err.println("Hit an elided word!");
        }
    }
}

