/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.baderlab.brain.AminoAcidGrouping;
import org.baderlab.brain.AvgLinkHierarchicalClustering;
import org.baderlab.brain.BrainParameterSet;
import org.baderlab.brain.DistanceMatrix;
import org.baderlab.brain.DistanceMetric;
import org.baderlab.brain.HierarchicalClusteringBootstrapResult;
import org.baderlab.brain.LogoTreeDraw;
import org.baderlab.brain.PeptideToProfileReader;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinProfileDistance;
import org.baderlab.brain.ProteinTerminus;
import org.baderlab.brain.util.FileReaderUtil;

public class HierarchicalClusteringBootstrapAnalysis {
    private static BrainParameterSet params = null;

    public static void runInputOrderRobustnessTest(String profileListFileName, int profileLength, ProteinTerminus terminus, int numberSamplings, String logoTreeTitle, File logoTreeOutput, File leafLabelHighlightFile, File codonBiasFile) {
        ArrayList<ProteinProfile> originalProfileList;
        params = new BrainParameterSet();
        params.setProfileFileName(new File(profileListFileName));
        params.setFuzzFactor(0.0);
        List<ProteinProfile> clusterProfileList = null;
        ArrayList<ProteinProfile> cutProfileList = null;
        clusterProfileList = originalProfileList = PeptideToProfileReader.readPeptidesAsProfiles(params.getProfileFile(), 0, null, params.getFuzzFactor(), codonBiasFile, true);
        if (profileLength > 0) {
            cutProfileList = new ArrayList<ProteinProfile>();
            for (int i = 0; i < originalProfileList.size(); ++i) {
                ProteinProfile proteinProfile = (ProteinProfile)originalProfileList.get(i);
                cutProfileList.add(proteinProfile.getTruncatedProfileCopy(profileLength, terminus));
            }
            clusterProfileList = cutProfileList;
        }
        AvgLinkHierarchicalClustering originalCluster = HierarchicalClusteringBootstrapAnalysis.clusterProfileList(clusterProfileList, true);
        HierarchicalClusteringBootstrapResult bootstrapResults = new HierarchicalClusteringBootstrapResult();
        AvgLinkHierarchicalClustering cluster = null;
        for (int i = 0; i < numberSamplings; ++i) {
            clusterProfileList = HierarchicalClusteringBootstrapAnalysis.randomizeList(clusterProfileList);
            cluster = HierarchicalClusteringBootstrapAnalysis.clusterProfileList(clusterProfileList, false);
            bootstrapResults.addClusterResults(cluster);
        }
        LogoTreeDraw ltd = new LogoTreeDraw(originalCluster, originalProfileList, null);
        ltd.setTrimNodeLogo(true, 0.15);
        ltd.setTitle(logoTreeTitle);
        ltd.setBootstrapResults(bootstrapResults);
        if (leafLabelHighlightFile != null) {
            ArrayList list = null;
            try {
                list = FileReaderUtil.readFileAsLineList(leafLabelHighlightFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ltd.setLeafLabelHighlightColor(list, Color.YELLOW);
        }
        ltd.setSequenceLogoStartIndex(-9);
        ltd.outputToPDF(logoTreeOutput);
    }

    private static AvgLinkHierarchicalClustering clusterProfileList(List clusterProfileList, boolean optimalLeafOrdering) {
        DistanceMatrix distanceMatrix = new DistanceMatrix(clusterProfileList.size());
        distanceMatrix.calcDistances(clusterProfileList, new DistanceMetric(){

            public double calc(Object object1, Object object2) {
                ProteinProfile proteinProfile1 = (ProteinProfile)object1;
                ProteinProfile proteinProfile2 = (ProteinProfile)object2;
                String groupingByPosition = AminoAcidGrouping.getPolarChargedHydrophobeGrouping();
                return ProteinProfileDistance.calculateAAGroupedDistributionDistance(proteinProfile1, proteinProfile2, groupingByPosition);
            }
        });
        ArrayList<String> al = new ArrayList<String>(clusterProfileList.size());
        for (int j = 0; j < clusterProfileList.size(); ++j) {
            ProteinProfile proteinProfile = (ProteinProfile)clusterProfileList.get(j);
            al.add(j, proteinProfile.getName());
        }
        distanceMatrix.setLabels(al);
        AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
        cluster.setOptimalLeafOrdering(optimalLeafOrdering);
        cluster.run();
        return cluster;
    }

    private static List randomizeList(List inputList) {
        int originalInputListSize = inputList.size();
        ArrayList randomizedInputList = new ArrayList(originalInputListSize);
        for (int i = 0; i < originalInputListSize; ++i) {
            randomizedInputList.add(inputList.remove((int)(Math.random() * (double)inputList.size())));
        }
        return randomizedInputList;
    }
}

