/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.task.ui;

import cytoscape.task.ui.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class JErrorPanel
extends JPanel {
    private static final long serialVersionUID = 333614801L;
    private Throwable t;
    private String userErrorMessage;
    private boolean showDetails = false;
    private JButton detailsButton;
    private JScrollPane detailsPane;
    private JDialog owner;
    private static final String SHOW_TEXT = "Show Error Details";
    private static final String HIDE_TEXT = "Hide Error Details";

    JErrorPanel(JDialog owner, Throwable t, String userErrorMessage) {
        if (owner == null) {
            throw new IllegalArgumentException("owner parameter is null.");
        }
        this.owner = owner;
        this.t = t;
        this.userErrorMessage = userErrorMessage;
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        JPanel northPanel = this.createNorthPanel();
        this.add((Component)northPanel, "North");
        JScrollPane centerPanel = this.createCenterPanel();
        this.add((Component)centerPanel, "Center");
        this.owner.pack();
        this.owner.validate();
    }

    private JPanel createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BoxLayout(panel, 0));
        if (this.userErrorMessage == null) {
            this.userErrorMessage = new String("An Error Has Occurred.  Please try again.");
        }
        JLabel errorLabel = new JLabel(StringUtils.truncateOrPadString("Error:  " + this.userErrorMessage));
        errorLabel.setForeground(Color.BLUE);
        Font font = errorLabel.getFont();
        errorLabel.setFont(new Font(font.getFamily(), 1, font.getSize()));
        errorLabel.setAlignmentY(0.0f);
        errorLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.add(errorLabel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(2, 1));
        buttonPanel.setAlignmentY(0.0f);
        this.conditionallyAddDetailsButton(buttonPanel);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JErrorPanel.this.owner.dispose();
            }
        });
        buttonPanel.add(closeButton);
        panel.add(buttonPanel);
        return panel;
    }

    private JScrollPane createCenterPanel() {
        this.detailsPane = new JScrollPane();
        if (this.t != null && this.t.getStackTrace() != null) {
            DefaultMutableTreeNode top;
            StackTraceElement[] ste = this.t.getStackTrace();
            Throwable cause = this.t.getCause();
            StringBuffer rootBuffer = null;
            if (cause != null) {
                rootBuffer = new StringBuffer("Root Cause:  " + cause.getClass().getName());
                if (cause.getMessage() != null) {
                    rootBuffer.append(":  " + cause.getMessage());
                }
            } else {
                rootBuffer = new StringBuffer(this.t.getClass().getName());
                if (this.t.getMessage() != null) {
                    rootBuffer.append(":  " + this.t.getMessage());
                }
            }
            DefaultMutableTreeNode current = top = new DefaultMutableTreeNode(rootBuffer.toString());
            for (int i = 0; i < ste.length; ++i) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(ste[i]);
                current.add(node);
                current = node;
            }
            JTree tree = new JTree(top);
            tree.scrollPathToVisible(new TreePath(current.getPath()));
            tree.setBorder(new EmptyBorder(4, 10, 10, 10));
            this.detailsPane.setViewportView(tree);
            this.detailsPane.setPreferredSize(new Dimension(10, 150));
        }
        this.detailsPane.setVisible(false);
        return this.detailsPane;
    }

    private void conditionallyAddDetailsButton(JPanel panel) {
        if (this.t != null && this.t.getStackTrace() != null) {
            this.detailsButton = new JButton(SHOW_TEXT);
            this.detailsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JErrorPanel.this.showDetails = !JErrorPanel.this.showDetails;
                    JErrorPanel.this.detailsPane.setVisible(JErrorPanel.this.showDetails);
                    JErrorPanel.this.owner.setResizable(JErrorPanel.this.showDetails);
                    if (JErrorPanel.this.showDetails) {
                        JErrorPanel.this.detailsButton.setText(JErrorPanel.HIDE_TEXT);
                    } else {
                        JErrorPanel.this.detailsButton.setText(JErrorPanel.SHOW_TEXT);
                    }
                    JErrorPanel.this.owner.pack();
                    JErrorPanel.this.owner.validate();
                }
            });
            this.detailsButton.setAlignmentX(1.0f);
            panel.add(this.detailsButton);
        }
    }
}

