/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.data.readers.GraphReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public class CyFileFilter
extends FileFilter
implements FilenameFilter {
    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";
    private Hashtable filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;
    protected GraphReader reader = null;
    protected String fileNature = "UNKNOWN";

    public CyFileFilter() {
    }

    public CyFileFilter(String extension) {
        this(extension, null, null);
    }

    public CyFileFilter(String extension, String description) {
        this(extension, description, null);
    }

    public CyFileFilter(String[] filters) {
        this(filters, null, null);
    }

    public CyFileFilter(String[] filters, String description) {
        this(filters, description, null);
    }

    public CyFileFilter(String extension, String description, String nature) {
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
        if (nature != null) {
            this.setFileNature(nature);
        }
    }

    public CyFileFilter(String[] filters, String description, String nature) {
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
        if (nature != null) {
            this.setFileNature(nature);
        }
    }

    public boolean accept(File f) {
        if (f != null) {
            if (this.filters.size() == 0) {
                return true;
            }
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.filters.get(extension) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean accept(File dir, String fileName) {
        return this.accept(new File(fileName));
    }

    public boolean accept(String fileName) {
        return this.accept(new File(fileName));
    }

    public String getExtension(File f) {
        if (f != null) {
            return this.getExtension(f.getName());
        }
        return null;
    }

    public String getExtension(String filename) {
        int i;
        if (filename != null && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + "*." + (String)(extensions.hasMoreElements() ? extensions.nextElement() : "*");
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", *." + (String)extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public Set getExtensionSet() {
        return this.filters.keySet();
    }

    public GraphReader getReader(String fileName) {
        return null;
    }

    public String getFileNature() {
        if (this.fileNature == null) {
            return null;
        }
        return this.fileNature;
    }

    public void setFileNature(String nature) {
        this.fileNature = nature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getHeader(File file) throws IOException {
        FileReader reader = null;
        BufferedReader bufferedReader = null;
        try {
            reader = new FileReader(file);
            bufferedReader = new BufferedReader(reader);
            String line = bufferedReader.readLine();
            StringBuffer header = new StringBuffer();
            for (int numLines = 0; line != null && numLines < 20; ++numLines) {
                header.append(line + "\n");
                line = bufferedReader.readLine();
            }
            String string = header.toString();
            return string;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }
}

