/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.giny;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNetworkEvent;
import cytoscape.CyNetworkListener;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.ExpressionData;
import cytoscape.data.FlagEventListener;
import cytoscape.data.FlagFilter;
import cytoscape.data.SelectEventListener;
import cytoscape.data.SelectFilter;
import cytoscape.util.intr.IntIterator;
import fing.model.FingExtensibleGraphPerspective;
import fing.model.FingExtensibleRootGraph;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FingCyNetwork
extends FingExtensibleGraphPerspective
implements CyNetwork,
GraphPerspective {
    private static int uid_counter = 0;
    private String identifier;
    protected String title;
    protected Set listeners = new HashSet();
    protected Map clientData;
    protected FlagFilter flagger;
    protected SelectFilter selectFilter;
    int activityCount = 0;

    public FingCyNetwork(FingExtensibleRootGraph root, IntIterator rootGraphNodeInx, IntIterator rootGraphEdgeInx) {
        super(root, rootGraphNodeInx, rootGraphEdgeInx);
        this.initialize();
    }

    protected void initialize() {
        Integer i = new Integer(uid_counter);
        this.identifier = i.toString();
        ++uid_counter;
        this.clientData = new HashMap();
        this.selectFilter = new SelectFilter(this);
        this.flagger = new FlagFilter(this.selectFilter);
    }

    public String getTitle() {
        if (this.title == null) {
            return this.identifier;
        }
        return this.title;
    }

    public void setTitle(String new_id) {
        this.title = new_id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String setIdentifier(String new_id) {
        this.identifier = new_id;
        return this.identifier;
    }

    public void putClientData(String data_name, Object data) {
        this.clientData.put(data_name, data);
    }

    public Collection getClientDataNames() {
        return this.clientData.keySet();
    }

    public Object getClientData(String data_name) {
        return this.clientData.get(data_name);
    }

    public void appendNetwork(CyNetwork network) {
        int[] nodes = network.getNodeIndicesArray();
        int[] edges = network.getEdgeIndicesArray();
        this.restoreNodes(nodes);
        this.restoreEdges(edges);
    }

    public ExpressionData getExpressionData() {
        return Cytoscape.getExpressionData();
    }

    public void setExpressionData(ExpressionData newData) {
    }

    public void selectAllNodes() {
        this.selectFilter.selectAllNodes();
    }

    public void selectAllEdges() {
        this.selectFilter.selectAllEdges();
    }

    public void unselectAllNodes() {
        this.selectFilter.unselectAllNodes();
    }

    public void unselectAllEdges() {
        this.selectFilter.unselectAllEdges();
    }

    public void setSelectedNodeState(Collection nodes, boolean selected_state) {
        this.selectFilter.setSelectedNodes(nodes, selected_state);
    }

    public void setSelectedNodeState(Node node, boolean selected_state) {
        this.selectFilter.setSelected(node, selected_state);
    }

    public void setSelectedEdgeState(Collection edges, boolean selected_state) {
        this.selectFilter.setSelectedEdges(edges, selected_state);
    }

    public void setSelectedEdgeState(Edge edge, boolean selected_state) {
        this.selectFilter.setSelected(edge, selected_state);
    }

    public boolean isSelected(Node node) {
        return this.selectFilter.isSelected(node);
    }

    public boolean isSelected(Edge edge) {
        return this.selectFilter.isSelected(edge);
    }

    public Set getSelectedNodes() {
        return this.selectFilter.getSelectedNodes();
    }

    public Set getSelectedEdges() {
        return this.selectFilter.getSelectedEdges();
    }

    public void addSelectEventListener(SelectEventListener listener) {
        this.selectFilter.addSelectEventListener(listener);
    }

    public void removeSelectEventListener(SelectEventListener listener) {
        this.selectFilter.removeSelectEventListener(listener);
    }

    public SelectFilter getSelectFilter() {
        return this.selectFilter;
    }

    public FlagFilter getFlagger() {
        return this.flagger;
    }

    public void flagAllNodes() {
        this.flagger.flagAllNodes();
    }

    public void flagAllEdges() {
        this.flagger.flagAllEdges();
    }

    public void unFlagAllNodes() {
        this.flagger.unflagAllNodes();
    }

    public void unFlagAllEdges() {
        this.flagger.unflagAllEdges();
    }

    public void setFlagged(Node node, boolean state) {
        this.flagger.setFlagged(node, state);
    }

    public void setFlaggedNodes(Collection nodes, boolean state) {
        this.flagger.setFlaggedNodes(nodes, state);
    }

    public void setFlaggedNodes(int[] nodes, boolean state) {
        for (int i = 0; i < nodes.length; ++i) {
            this.flagger.setFlagged(this.getNode(nodes[i]), state);
        }
    }

    public void setFlagged(Edge edge, boolean state) {
        this.flagger.setFlagged(edge, state);
    }

    public void setFlaggedEdges(Collection edges, boolean state) {
        this.flagger.setFlaggedEdges(edges, state);
    }

    public void setFlaggedEdges(int[] edges, boolean state) {
        for (int i = 0; i < edges.length; ++i) {
            this.flagger.setFlagged(this.getEdge(edges[i]), state);
        }
    }

    public boolean isFlagged(Node node) {
        return this.flagger.isFlagged(node);
    }

    public boolean isFlagged(Edge edge) {
        return this.flagger.isFlagged(edge);
    }

    public Set getFlaggedNodes() {
        return this.flagger.getFlaggedNodes();
    }

    public Set getFlaggedEdges() {
        return this.flagger.getFlaggedEdges();
    }

    public int[] getFlaggedNodeIndicesArray() {
        Set set = this.flagger.getFlaggedNodes();
        int[] nodes = new int[set.size()];
        int count = 0;
        Iterator i = set.iterator();
        while (i.hasNext()) {
            nodes[count] = ((Node)i.next()).getRootGraphIndex();
            ++count;
        }
        return nodes;
    }

    public int[] getFlaggedEdgeIndicesArray() {
        Set set = this.flagger.getFlaggedEdges();
        int[] edges = new int[set.size()];
        int count = 0;
        Iterator i = set.iterator();
        while (i.hasNext()) {
            edges[count] = ((Edge)i.next()).getRootGraphIndex();
            ++count;
        }
        return edges;
    }

    public void addFlagEventListener(FlagEventListener listener) {
        this.flagger.addFlagEventListener(listener);
    }

    public void removeFlagEventListener(FlagEventListener listener) {
        this.flagger.removeFlagEventListener(listener);
    }

    public Object getNodeAttributeValue(Node node, String attribute) {
        return this.getNodeAttributeValue(node.getRootGraphIndex(), attribute);
    }

    public Object getNodeAttributeValue(int node, String attribute) {
        String canonName = this.getNode(node).getIdentifier();
        CyAttributes attrs = Cytoscape.getNodeAttributes();
        byte cyType = attrs.getType(attribute);
        if (cyType == 1) {
            return attrs.getBooleanAttribute(canonName, attribute);
        }
        if (cyType == 2) {
            return attrs.getDoubleAttribute(canonName, attribute);
        }
        if (cyType == 3) {
            return attrs.getIntegerAttribute(canonName, attribute);
        }
        if (cyType == 4) {
            return attrs.getStringAttribute(canonName, attribute);
        }
        if (cyType == -2) {
            return attrs.getListAttribute(canonName, attribute);
        }
        if (cyType == -3) {
            return attrs.getMapAttribute(canonName, attribute);
        }
        return null;
    }

    public Object getEdgeAttributeValue(Edge edge, String attribute) {
        return this.getEdgeAttributeValue(edge.getRootGraphIndex(), attribute);
    }

    public Object getEdgeAttributeValue(int edge, String attribute) {
        String canonName = this.getEdge(edge).getIdentifier();
        CyAttributes attrs = Cytoscape.getEdgeAttributes();
        byte cyType = attrs.getType(attribute);
        if (cyType == 1) {
            return attrs.getBooleanAttribute(canonName, attribute);
        }
        if (cyType == 2) {
            return attrs.getDoubleAttribute(canonName, attribute);
        }
        if (cyType == 3) {
            return attrs.getIntegerAttribute(canonName, attribute);
        }
        if (cyType == 4) {
            return attrs.getStringAttribute(canonName, attribute);
        }
        if (cyType == -2) {
            return attrs.getListAttribute(canonName, attribute);
        }
        if (cyType == -3) {
            return attrs.getMapAttribute(canonName, attribute);
        }
        return null;
    }

    public String[] getNodeAttributesList() {
        return Cytoscape.getNodeAttributes().getAttributeNames();
    }

    public String[] getNodeAttributesList(Node[] nodes) {
        return Cytoscape.getNodeAttributes().getAttributeNames();
    }

    public String[] getEdgeAttributesList() {
        return Cytoscape.getEdgeAttributes().getAttributeNames();
    }

    public String[] getNodeAttributesList(Edge[] edges) {
        return Cytoscape.getEdgeAttributes().getAttributeNames();
    }

    public boolean setNodeAttributeValue(Node node, String attribute, Object value) {
        return this.setNodeAttributeValue(node.getRootGraphIndex(), attribute, value);
    }

    public boolean setNodeAttributeValue(int node, String attribute, Object value) {
        String canonName = this.getNode(node).getIdentifier();
        CyAttributes attrs = Cytoscape.getNodeAttributes();
        if (value instanceof Boolean) {
            attrs.setAttribute(canonName, attribute, (Boolean)value);
            return true;
        }
        if (value instanceof Integer) {
            attrs.setAttribute(canonName, attribute, (Integer)value);
            return true;
        }
        if (value instanceof Double) {
            attrs.setAttribute(canonName, attribute, (Double)value);
            return true;
        }
        if (value instanceof String) {
            attrs.setAttribute(canonName, attribute, (String)value);
            return true;
        }
        if (value instanceof List) {
            attrs.setListAttribute(canonName, attribute, (List)value);
            return true;
        }
        if (value instanceof Map) {
            attrs.setMapAttribute(canonName, attribute, (Map)value);
            return true;
        }
        return false;
    }

    public boolean setEdgeAttributeValue(Edge edge, String attribute, Object value) {
        return this.setEdgeAttributeValue(edge.getRootGraphIndex(), attribute, value);
    }

    public boolean setEdgeAttributeValue(int edge, String attribute, Object value) {
        String canonName = this.getEdge(edge).getIdentifier();
        CyAttributes attrs = Cytoscape.getEdgeAttributes();
        if (value instanceof Boolean) {
            attrs.setAttribute(canonName, attribute, (Boolean)value);
            return true;
        }
        if (value instanceof Integer) {
            attrs.setAttribute(canonName, attribute, (Integer)value);
            return true;
        }
        if (value instanceof Double) {
            attrs.setAttribute(canonName, attribute, (Double)value);
            return true;
        }
        if (value instanceof String) {
            attrs.setAttribute(canonName, attribute, (String)value);
            return true;
        }
        if (value instanceof List) {
            attrs.setListAttribute(canonName, attribute, (List)value);
            return true;
        }
        if (value instanceof Map) {
            attrs.setMapAttribute(canonName, attribute, (Map)value);
            return true;
        }
        return false;
    }

    public void deleteNodeAttribute(String attribute) {
        Cytoscape.getNodeAttributes().deleteAttribute(attribute);
    }

    public void deleteEdgeAttribute(String attribute) {
        Cytoscape.getEdgeAttributes().deleteAttribute(attribute);
    }

    public void addCyNetworkListener(CyNetworkListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeCyNetworkListener(CyNetworkListener listener) {
        return this.listeners.remove(listener);
    }

    public Set getCyNetworkListeners() {
        return new HashSet(this.listeners);
    }

    protected void fireEvent(int type) {
        CyNetworkEvent event = new CyNetworkEvent(this, type);
        for (CyNetworkListener listener : this.listeners) {
            listener.onCyNetworkEvent(event);
        }
    }

    public int createNode() {
        return this.restoreNode(Cytoscape.getRootGraph().createNode());
    }

    public int addNode(int cytoscape_node) {
        return this.restoreNode(cytoscape_node);
    }

    public CyNode addNode(Node cytoscape_node) {
        return (CyNode)this.restoreNode(cytoscape_node);
    }

    public int addNode(String attribute, Object value) {
        return 0;
    }

    public boolean removeNode(int node_index, boolean force) {
        this.hideNode(node_index);
        return true;
    }

    public int createEdge(int source, int target, boolean directed) {
        return this.restoreEdge(Cytoscape.getRootGraph().createEdge(source, target, directed));
    }

    public int addEdge(int cytoscape_edge) {
        return this.restoreEdge(cytoscape_edge);
    }

    public CyEdge addEdge(Edge cytoscape_edge) {
        return (CyEdge)this.restoreEdge(cytoscape_edge);
    }

    public int addEdge(String attribute, Object value) {
        return 0;
    }

    public boolean removeEdge(int edge_index, boolean force) {
        super.hideEdge(edge_index);
        return true;
    }
}

