/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.visual.Arrow;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.calculators.AbstractEdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import giny.model.Edge;
import java.util.Properties;

public class GenericEdgeArrowCalculator
extends AbstractEdgeArrowCalculator
implements EdgeArrowCalculator {
    public byte getType() {
        return this.arrowType;
    }

    public String getPropertyLabel() {
        return this.propertyLabel;
    }

    public String getTypeName() {
        return this.typename;
    }

    protected String getClassName() {
        if (this.arrowType == 10) {
            return "cytoscape.visual.calculators.GenericEdgeSourceArrowCalculator";
        }
        if (this.arrowType == 11) {
            return "cytoscape.visual.calculators.GenericEdgeTargetArrowCalculator";
        }
        return this.getClass().getName();
    }

    GenericEdgeArrowCalculator() {
        this.set((byte)11, "edgeSourceTargetCalculator", "Edge Target Arrow");
    }

    public GenericEdgeArrowCalculator(String name, ObjectMapping m) {
        super(name, m);
        this.set((byte)11, "edgeSourceTargetCalculator", "Edge Target Arrow");
    }

    public GenericEdgeArrowCalculator(String name, Properties props, String baseKey) {
        super(name, props, baseKey);
        this.set((byte)11, "edgeSourceTargetCalculator", "Edge Target Arrow");
    }

    public void apply(EdgeAppearance appr, Edge edge, CyNetwork network) {
        if (this.arrowType == 10) {
            this.apply(appr, edge, network, (byte)0);
        } else if (this.arrowType == 11) {
            this.apply(appr, edge, network, (byte)1);
        } else {
            System.err.println("don't know what kind of calculator this is!");
        }
    }

    public Arrow calculateEdgeArrow(Edge e, CyNetwork n) {
        EdgeAppearance ea = new EdgeAppearance();
        this.apply(ea, e, n);
        if (this.arrowType == 10) {
            return ea.getSourceArrow();
        }
        if (this.arrowType == 11) {
            return ea.getTargetArrow();
        }
        return null;
    }
}

