/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.AllTests;
import cytoscape.Cytoscape;
import cytoscape.data.readers.XGMMLReader;
import cytoscape.giny.CytoscapeRootGraph;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class XGMMLReaderTest
extends TestCase {
    private static String testDataDir;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Error!  must supply path to test data directory on command line");
            Cytoscape.exit(0);
        }
        testDataDir = args[0];
        TestRunner.run((Test)new TestSuite(XGMMLReaderTest.class));
    }

    public XGMMLReaderTest(String arg0) {
        super(arg0);
        if (AllTests.runAllTests()) {
            testDataDir = "testData";
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testXGMMLGraphRead() throws Exception {
        AllTests.standardOut("testXGMMLGraphRead");
        XGMMLReader reader = new XGMMLReader("testData/galFiltered2.xgmml");
        File testfile = new File("testData/galFiltered2.xgmml");
        if (testfile.canRead()) {
            System.out.println("Reading XGMML: " + testfile.getAbsolutePath());
            CytoscapeRootGraph network = Cytoscape.getRootGraph();
            network.removeNodes(network.nodesList());
            reader.read();
            if (network == null) {
                System.out.println("Root Graph is null!");
                return;
            }
            System.out.println("XGMMLReader: Node count = " + network.getNodeCount());
            System.out.println("XGMMLReader: Edge count = " + network.getEdgeCount());
            XGMMLReaderTest.assertTrue((String)("XGMMLReader: Node count, expect 331, got " + network.getNodeCount()), (network.getNodeCount() == 331 ? 1 : 0) != 0);
            XGMMLReaderTest.assertTrue((String)("XGMMLReader: Edge count, expect 362, got " + network.getEdgeCount()), (network.getEdgeCount() == 362 ? 1 : 0) != 0);
        } else {
            System.out.println("No such file");
        }
    }
}

