/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.ontology;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.ontology.DBReference;
import cytoscape.data.ontology.GOTerm;
import cytoscape.data.ontology.Ontology;
import cytoscape.data.ontology.readers.OBOTags;
import cytoscape.data.readers.MetadataEntries;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import org.biojava.ontology.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneOntology
extends Ontology {
    private CyAttributes goTermAttributes = Cytoscape.getNodeAttributes();

    public GeneOntology(String name, String curator, String description, CyNetwork dag) throws URISyntaxException, MalformedURLException {
        super(name, curator, description, dag);
        DBReference reference = Cytoscape.getOntologyServer().getCrossReferences().getDBReference("GOC");
        this.metaParser.setMetadata(MetadataEntries.SOURCE, reference.getGenericURL().toString());
    }

    @Override
    public String getCurator() {
        return null;
    }

    public List<Term> getTermsInNamespace(String namespace) {
        return null;
    }

    public GOTerm getGOTerm(String goID) {
        return new GOTerm(goID, Cytoscape.getNodeAttributes().getStringAttribute(goID, OBOTags.getPrefix() + "." + OBOTags.NAME.toString()), this.name, this.goTermAttributes.getStringAttribute(goID, OBOTags.getPrefix() + "." + OBOTags.DEF.toString()));
    }

    public GOAspect getAspect(String goID) {
        String nameSpace = this.goTermAttributes.getStringAttribute(goID, OBOTags.getPrefix() + "." + OBOTags.NAMESPACE.toString());
        if (nameSpace == null) {
            return null;
        }
        if (nameSpace.equalsIgnoreCase(GOAspect.BIOLOGICAL_PROCESS.name())) {
            return GOAspect.BIOLOGICAL_PROCESS;
        }
        if (nameSpace.equalsIgnoreCase(GOAspect.CELLULAR_COMPONENT.name())) {
            return GOAspect.CELLULAR_COMPONENT;
        }
        if (nameSpace.equalsIgnoreCase(GOAspect.MOLECULAR_FUNCTION.name())) {
            return GOAspect.MOLECULAR_FUNCTION;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GOAspect {
        BIOLOGICAL_PROCESS("P"),
        CELLULAR_COMPONENT("C"),
        MOLECULAR_FUNCTION("F");

        private String aspect;

        private GOAspect(String aspect) {
            this.aspect = aspect;
        }

        public String toString() {
            return this.aspect;
        }
    }
}

