/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.Cytoscape;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class MacAppConfig {
    private String configFile = "Cytoscape.app/Contents/Info.plist";

    public void configure() throws IOException, JDOMException {
        Document doc = this.getConfiguration();
        String[] files = this.getJarList();
        Element root = doc.getRootElement();
        Element dict = root.getChild("dict");
        dict = dict.getChild("dict");
        Element array = dict.getChild("JAR_ARRAY");
        array.setName("array");
        this.addJars(files, array);
        XMLOutputter outputter = new XMLOutputter("     ", false);
        FileWriter writer = new FileWriter(this.configFile);
        outputter.output(doc, (Writer)writer);
        writer.close();
        System.out.println("File is now updated with correct JARs:  " + this.configFile);
    }

    private void addJars(String[] files, Element array) {
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            if (!file.endsWith("jar")) continue;
            Element jar = new Element("string");
            jar.setText("$JAVAROOT/" + file);
            array.addContent(jar);
            array.addContent("\n");
        }
    }

    private String[] getJarList() {
        File dir = new File("lib");
        String[] files = dir.list();
        return files;
    }

    private Document getConfiguration() throws IOException, JDOMException {
        Document doc = null;
        try {
            FileReader reader = new FileReader(this.configFile);
            SAXBuilder saxBuilder = new SAXBuilder();
            doc = saxBuilder.build((Reader)reader);
        }
        catch (FileNotFoundException e) {
            System.out.println("Cannot find:  " + this.configFile);
            System.out.println("Try running:  'ant mac' first.");
            Cytoscape.exit(-1);
        }
        return doc;
    }

    public static void main(String[] args) throws Exception {
        MacAppConfig mac = new MacAppConfig();
        mac.configure();
    }
}

