/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font;

import java.awt.Shape;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.QuadToCubicPathConstructor;

public class CharstringEncoder
extends QuadToCubicPathConstructor {
    private static final int LAST_POINT = 0;
    private static final int HORIZONTAL = 1;
    private static final int VERTICAL = 2;
    private static final int BOTH = 3;
    private OutputStream out;
    private int currentX;
    private int currentY;

    public CharstringEncoder(OutputStream out) {
        this.out = out;
        this.currentY = 0;
        this.currentX = 0;
    }

    private int writeNumber(double v) throws IOException {
        int round = (int)Math.round(v);
        this.writeNumber(round);
        return round;
    }

    private void writeNumber(int v) throws IOException {
        if (v >= -107 && v <= 107) {
            this.out.write(v + 139);
        } else if (v >= 108 && v <= 1131) {
            int highByte = (v - 108) / 256;
            this.out.write(highByte + 247);
            this.out.write(v - 108 - 256 * highByte);
        } else if (v >= -1131 && v <= -108) {
            int highByte = (v + 108) / 256;
            this.out.write(-highByte + 251);
            this.out.write(-(v + 108 - 256 * highByte));
        } else {
            this.out.write(255);
            this.out.write(v >>> 24 & 0xFF);
            this.out.write(v >>> 16 & 0xFF);
            this.out.write(v >>> 8 & 0xFF);
            this.out.write(v >>> 0 & 0xFF);
        }
    }

    private void writeCommand(int com) throws IOException {
        if (com >= 31) {
            throw new IOException("Charstring command out of range: " + com);
        }
        this.out.write(com);
    }

    private void writeExtCommand(int com) throws IOException {
        this.out.write(12);
        this.out.write(com);
    }

    private void writePoint(double x, double y) throws IOException {
        this.currentX += this.writeNumber(x - (double)this.currentX);
        this.currentY += this.writeNumber(y - (double)this.currentY);
    }

    private void writeX(double x) throws IOException {
        this.currentX += this.writeNumber(x - (double)this.currentX);
    }

    private void writeY(double y) throws IOException {
        this.currentY += this.writeNumber(y - (double)this.currentY);
    }

    public void startChar(double sidebearing, double width) throws IOException {
        this.currentX = this.writeNumber(sidebearing);
        this.writeNumber(width);
        this.writeCommand(13);
    }

    public void endchar() throws IOException {
        this.writeCommand(14);
    }

    private int to(double x, double y) throws IOException {
        int rx = (int)Math.round(x);
        int ry = (int)Math.round(y);
        if (rx == this.currentX) {
            if (ry == this.currentY) {
                return 0;
            }
            this.writeY(y);
            return 2;
        }
        if (ry == this.currentY) {
            this.writeX(x);
            return 1;
        }
        this.writePoint(x, y);
        return 3;
    }

    public void move(double x, double y) throws IOException {
        switch (this.to(x, y)) {
            case 3: {
                this.writeCommand(21);
                break;
            }
            case 1: {
                this.writeCommand(22);
                break;
            }
            case 2: {
                this.writeCommand(4);
                break;
            }
        }
        super.move(x, y);
    }

    public void line(double x, double y) throws IOException {
        switch (this.to(x, y)) {
            case 3: {
                this.writeCommand(5);
                break;
            }
            case 1: {
                this.writeCommand(6);
                break;
            }
            case 2: {
                this.writeCommand(7);
                break;
            }
        }
        super.line(x, y);
    }

    public void cubic(double x1, double y1, double x2, double y2, double x3, double y3) throws IOException {
        this.writePoint(x1, y1);
        this.writePoint(x2, y2);
        this.writePoint(x3, y3);
        this.writeCommand(8);
        super.cubic(x1, y1, x2, y2, x3, y3);
    }

    public void closePath(double x0, double y0) throws IOException {
        this.writeCommand(9);
        super.closePath(x0, y0);
    }

    public void drawPath(Shape s) throws IOException {
        this.addPath(s);
    }
}

