/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.BitSet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableColumnSelector {
    private BitSet hidden = new BitSet();
    private TableModel source;
    private TableModel result;
    private EventListenerList listeners = new EventListenerList();
    private TableModelListener internalListener = new InternalTableModelListener();

    public TableColumnSelector(TableModel model) {
        this.source = model;
        this.result = new InternalTableModel();
    }

    private int mapFromFilter(int columnIndex) {
        int result = columnIndex;
        if (!this.hidden.isEmpty()) {
            int i = 0;
            while (columnIndex >= 0) {
                if (!this.hidden.get(i)) {
                    --columnIndex;
                } else {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    private int mapToFilter(int columnIndex) {
        int result = columnIndex;
        if (!this.hidden.isEmpty()) {
            for (int i = 0; i < columnIndex; ++i) {
                if (!this.hidden.get(i)) continue;
                --result;
            }
        }
        return result;
    }

    public void populateMenu(JComponent menu) {
        ActionListener l = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = Integer.parseInt(e.getActionCommand());
                boolean hide = !((JCheckBoxMenuItem)e.getSource()).isSelected();
                TableColumnSelector.this.setHideColumn(i, hide);
            }
        };
        for (int i = 0; i < this.source.getColumnCount(); ++i) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(this.source.getColumnName(i));
            item.setActionCommand(String.valueOf(i));
            item.setSelected(!this.hidden.get(i));
            item.addActionListener(l);
            menu.add(item);
        }
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu result = new JPopupMenu(){

            protected void firePopupMenuWillBecomeVisible() {
                TableColumnSelector.this.populateMenu(this);
            }

            protected void firePopupMenuWillBecomeInvisible() {
                this.removeAll();
            }
        };
        return result;
    }

    public void setHideColumn(int columnIndex, boolean hide) {
        if (hide != this.hidden.get(columnIndex)) {
            this.hidden.set(columnIndex, hide);
            if (this.listeners.getListenerCount() != 0) {
                int type = hide ? -1 : 1;
                int column = this.mapToFilter(columnIndex);
                TableModelEvent event = new TableModelEvent(this.result, -1, -1, column, type);
                this.fireTableChanged(event);
            }
        }
    }

    protected void fireTableChanged(TableModelEvent event) {
        TableModelListener[] l = (TableModelListener[])this.listeners.getListeners(TableModelListener.class);
        for (int i = 0; i < l.length; ++i) {
            l[i].tableChanged(event);
        }
    }

    public boolean isHideColumn(int columnIndex) {
        return this.hidden.get(columnIndex);
    }

    public TableModel getFilteredTableModel() {
        return this.result;
    }

    private class InternalTableModelListener
    implements TableModelListener {
        private InternalTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            int column = e.getColumn();
            if (column == -1 || !TableColumnSelector.this.hidden.get(column)) {
                int first = e.getFirstRow();
                int last = e.getLastRow();
                int type = e.getType();
                if (column != -1) {
                    column = TableColumnSelector.this.mapToFilter(column);
                }
                TableModelEvent ee = new TableModelEvent(TableColumnSelector.this.result, first, last, column, type);
                TableColumnSelector.this.fireTableChanged(ee);
            }
        }
    }

    private class InternalTableModel
    implements TableModel {
        private InternalTableModel() {
        }

        public void addTableModelListener(TableModelListener l) {
            if (TableColumnSelector.this.listeners.getListenerCount() == 0) {
                TableColumnSelector.this.source.addTableModelListener(TableColumnSelector.this.internalListener);
            }
            TableColumnSelector.this.listeners.add(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = TableColumnSelector.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener, l);
        }

        public Class getColumnClass(int columnIndex) {
            return TableColumnSelector.this.source.getColumnClass(TableColumnSelector.this.mapFromFilter(columnIndex));
        }

        public int getColumnCount() {
            return TableColumnSelector.this.source.getColumnCount() - TableColumnSelector.this.hidden.cardinality();
        }

        public String getColumnName(int columnIndex) {
            return TableColumnSelector.this.source.getColumnName(TableColumnSelector.this.mapFromFilter(columnIndex));
        }

        public int getRowCount() {
            return TableColumnSelector.this.source.getRowCount();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return TableColumnSelector.this.source.getValueAt(rowIndex, TableColumnSelector.this.mapFromFilter(columnIndex));
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return TableColumnSelector.this.source.isCellEditable(rowIndex, TableColumnSelector.this.mapFromFilter(columnIndex));
        }

        public void removeTableModelListener(TableModelListener l) {
            TableColumnSelector.this.listeners.remove(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = TableColumnSelector.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener, l);
            if (TableColumnSelector.this.listeners.getListenerCount() == 0) {
                TableColumnSelector.this.source.removeTableModelListener(TableColumnSelector.this.internalListener);
            }
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            TableColumnSelector.this.source.setValueAt(aValue, rowIndex, TableColumnSelector.this.mapFromFilter(columnIndex));
        }
    }
}

