/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public interface ImageMap {
    public static final String RECT = "rect";
    public static final String CIRCLE = "circle";
    public static final String POLY = "poly";

    public void addHotSpot(HotSpot var1);

    public Iterator hotSpots();

    public static class ServerSide
    implements ImageMap,
    Serializable {
        private List hotSpots = new ArrayList();

        public void addHotSpot(HotSpot hotSpot) {
            this.hotSpots.add(hotSpot);
        }

        public Iterator hotSpots() {
            return this.hotSpots.iterator();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Iterator hi = this.hotSpots.iterator();
            while (hi.hasNext()) {
                HotSpot hs = (HotSpot)hi.next();
                Integer[] coords = hs.getCoordinates();
                sb.append(hs.getType());
                sb.append(" ");
                sb.append(hs.getURL().toString());
                sb.append(" ");
                for (int i = 0; i < coords.length - 1; i += 2) {
                    sb.append(coords[i]);
                    sb.append(",");
                    sb.append(coords[i + 1]);
                    sb.append(" ");
                }
            }
            return sb.substring(0).trim();
        }
    }

    public static class ClientSide
    implements ImageMap,
    Serializable {
        private String name;
        private URL url;
        private List hotSpots;

        public ClientSide(String name) {
            this.name = name;
            this.hotSpots = new ArrayList();
        }

        public void addHotSpot(HotSpot hotSpot) {
            this.hotSpots.add(hotSpot);
        }

        public Iterator hotSpots() {
            return this.hotSpots.iterator();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<map name=");
            sb.append("\"");
            sb.append(this.name);
            sb.append("\">\n");
            Iterator hi = this.hotSpots.iterator();
            while (hi.hasNext()) {
                HotSpot hs = (HotSpot)hi.next();
                Integer[] coords = hs.getCoordinates();
                sb.append("<area shape=\"");
                sb.append(hs.getType());
                sb.append("\" href=\"");
                sb.append(hs.getURL().toString());
                sb.append("\" coords=\"");
                int lastDelim = coords.length - 1;
                char delim = ',';
                for (int i = 0; i < coords.length; ++i) {
                    sb.append(coords[i]);
                    if (i > lastDelim) continue;
                    sb.append(delim);
                }
                sb.append("\">\n");
            }
            sb.append("</map>");
            return sb.substring(0);
        }
    }

    public static final class HotSpot
    implements Serializable {
        private String type;
        private URL url;
        private Integer[] coordinates;
        private Object userObject;

        public HotSpot(String type, URL url, Integer[] coordinates) {
            if (type != ImageMap.RECT && type != ImageMap.CIRCLE && type != ImageMap.POLY) {
                throw new IllegalArgumentException("Failed to create HotSpot. Constructor was passed an invalid type '" + type + "'");
            }
            if (coordinates.length % 2 != 0) {
                throw new IllegalArgumentException("Failed to create HotSpot. The coordinates array contained an odd number of points");
            }
            this.type = type;
            this.url = url;
            this.coordinates = coordinates;
        }

        public HotSpot(String type, URL url, Integer[] coordinates, Object userObject) {
            this(type, url, coordinates);
            this.userObject = userObject;
        }

        public String getType() {
            return this.type;
        }

        public URL getURL() {
            return this.url;
        }

        public Integer[] getCoordinates() {
            return this.coordinates;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object userObject) {
            this.userObject = userObject;
        }

        public String toString() {
            return "HotSpot to " + this.url.toString();
        }
    }
}

