/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.AllTests;
import cytoscape.util.Exec;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ExecTest
extends TestCase {
    public ExecTest(String name) {
        super(name);
    }

    public void notestBasic() {
        String newLine;
        AllTests.standardOut("testBasic");
        String[] cmd = new String[]{"echo", "hello", "world"};
        Exec child = new Exec(cmd);
        int result = child.run();
        ExecTest.assertTrue((result == 0 ? 1 : 0) != 0);
        Enumeration iterator = child.getStdout().elements();
        StringBuffer sb = new StringBuffer();
        sb.append("=========== STDOUT =============\n");
        while (iterator.hasMoreElements()) {
            newLine = (String)iterator.nextElement();
            sb.append(newLine);
            sb.append("\n");
        }
        iterator = child.getStderr().elements();
        sb.append("=========== STDERR =============\n");
        while (iterator.hasMoreElements()) {
            newLine = (String)iterator.nextElement();
            sb.append(newLine);
            sb.append("\n");
        }
        String fullResult = sb.toString();
        ExecTest.assertTrue((fullResult.indexOf("world") >= 0 ? 1 : 0) != 0);
    }

    public void testBasicWithThreadedExec() throws Exception {
        AllTests.standardOut("testBasicWithThreadedExec");
        String[] cmd = new String[]{"echo", "hello", "world"};
        Exec child = new Exec(cmd);
        int result = child.runThreaded();
        ExecTest.assertTrue((result == 0 ? 1 : 0) != 0);
        String stdout = child.getStdoutAsString();
        String stderr = child.getStderrAsString();
        AllTests.standardOut("stdout: " + stdout);
        AllTests.standardOut("stderr: " + stderr);
    }

    public void testBasicWithThreadedExec2() throws Exception {
        AllTests.standardOut("testBasicWithThreadedExec2");
        String[] cmd = new String[]{"echo", "hello", "world"};
        Exec child = new Exec(cmd);
        int result = child.runThreaded();
        ExecTest.assertTrue((result == 0 ? 1 : 0) != 0);
        String stdout = child.getStdoutAsString();
        String stderr = child.getStderrAsString();
        AllTests.standardOut("stdout: " + stdout);
        AllTests.standardOut("stderr: " + stderr);
    }

    public void notestBasicInBackground() {
        String newLine;
        AllTests.standardOut("testBasicInBackground");
        String[] cmd = new String[]{"echo", "hello", "world"};
        Exec child = new Exec(cmd);
        child.setRunInBackground(true);
        AllTests.standardOut("cmd: " + child.getCmd());
        int result = child.run();
        Enumeration iterator = child.getStdout().elements();
        StringBuffer sb = new StringBuffer();
        sb.append("=========== STDOUT =============\n");
        while (iterator.hasMoreElements()) {
            newLine = (String)iterator.nextElement();
            sb.append(newLine);
            AllTests.standardOut(newLine);
            sb.append("\n");
        }
        iterator = child.getStderr().elements();
        sb.append("=========== STDERR =============\n");
        while (iterator.hasMoreElements()) {
            newLine = (String)iterator.nextElement();
            AllTests.standardOut(newLine);
            sb.append(newLine);
            sb.append("\n");
        }
        String fullResult = sb.toString();
        ExecTest.assertTrue((fullResult.indexOf("world") >= 0 ? 1 : 0) != 0);
        AllTests.standardOut("--> " + fullResult + " <--");
    }

    public void notestUsingStandardInput() {
        String newLine;
        AllTests.standardOut("testUsingStandardInput");
        String[] cmd = new String[]{"cat"};
        Exec child = new Exec(cmd);
        child.setStandardInput("sample input\nsent to cat\nto be echoed\n");
        int result = child.run();
        ExecTest.assertTrue((result == 0 ? 1 : 0) != 0);
        Enumeration iterator = child.getStdout().elements();
        StringBuffer sb = new StringBuffer();
        while (iterator.hasMoreElements()) {
            newLine = (String)iterator.nextElement();
            sb.append(newLine);
            sb.append("\n");
        }
        ExecTest.assertTrue((sb.toString().indexOf("sample input") >= 0 ? 1 : 0) != 0);
        ExecTest.assertTrue((sb.toString().indexOf("sent to cat") >= 0 ? 1 : 0) != 0);
        ExecTest.assertTrue((sb.toString().indexOf("to be echoed") >= 0 ? 1 : 0) != 0);
        iterator = child.getStderr().elements();
        sb = new StringBuffer();
        while (iterator.hasMoreElements()) {
            newLine = (String)iterator.nextElement();
            sb.append(newLine);
            sb.append("\n");
        }
        String stderr = sb.toString();
        ExecTest.assertTrue((stderr.length() == 0 ? 1 : 0) != 0);
    }

    public void disabled_testRunNetscape() {
        String newLine;
        String[] cmd = new String[]{"/users/pshannon/data/human/jdrf/web", "http://sewardpark.net"};
        Exec child = new Exec(cmd);
        int result = child.run();
        ExecTest.assertTrue((result == 0 ? 1 : 0) != 0);
        Enumeration iterator = child.getStdout().elements();
        StringBuffer sb = new StringBuffer();
        sb.append("=========== STDOUT =============\n");
        while (iterator.hasMoreElements()) {
            newLine = (String)iterator.nextElement();
            sb.append(newLine);
            sb.append("\n");
        }
        iterator = child.getStderr().elements();
        sb.append("=========== STDERR =============\n");
        while (iterator.hasMoreElements()) {
            newLine = (String)iterator.nextElement();
            sb.append(newLine);
            sb.append("\n");
        }
        String fullResult = sb.toString();
        AllTests.standardOut(fullResult);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(ExecTest.class));
    }
}

