/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import java.util.StringTokenizer;
import java.util.Vector;

public class Interaction {
    private String source;
    private Vector targets = new Vector();
    private String interactionType;
    private Vector allInteractions = new Vector();

    public Interaction(String source, String target, String interactionType) {
        this.source = source;
        this.interactionType = interactionType;
        this.targets.addElement(target);
    }

    public Interaction(String rawText) {
        this(rawText, " ");
    }

    public Interaction(String rawText, String delimiter) {
        StringTokenizer strtok = new StringTokenizer(rawText, delimiter);
        int counter = 0;
        while (strtok.hasMoreTokens()) {
            if (counter == 0) {
                this.source = strtok.nextToken().trim();
            } else if (counter == 1) {
                this.interactionType = strtok.nextToken().trim();
            } else {
                String newTarget = strtok.nextToken().trim();
                this.targets.addElement(newTarget);
            }
            ++counter;
        }
    }

    public String getSource() {
        return this.source;
    }

    public String getType() {
        return this.interactionType;
    }

    public int numberOfTargets() {
        return this.targets.size();
    }

    public String[] getTargets() {
        String[] result = new String[this.targets.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)this.targets.elementAt(i);
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.interactionType);
        sb.append("::");
        sb.append(this.source);
        sb.append("::");
        for (int i = 0; i < this.targets.size(); ++i) {
            sb.append((String)this.targets.elementAt(i));
            if (i >= this.targets.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

