/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.Cytoscape;
import cytoscape.data.FlagEvent;
import cytoscape.data.FlagFilter;
import cytoscape.giny.CytoscapeRootGraph;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FlagEventTest
extends TestCase {
    public FlagEventTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testConstants() throws Exception {
        FlagEventTest.assertTrue((boolean)true);
        FlagEventTest.assertTrue((boolean)true);
        FlagEventTest.assertTrue((boolean)true);
        FlagEventTest.assertTrue((boolean)true);
        FlagEventTest.assertTrue((boolean)true);
        FlagEventTest.assertTrue((boolean)true);
    }

    public void testCtor() throws Exception {
        CytoscapeRootGraph rootGraph = Cytoscape.getRootGraph();
        Node node1 = rootGraph.getNode(rootGraph.createNode());
        Node node2 = rootGraph.getNode(rootGraph.createNode());
        Edge edge1 = rootGraph.getEdge(rootGraph.createEdge(node1, node2));
        Edge edge2 = rootGraph.getEdge(rootGraph.createEdge(node2, node1));
        Node[] nodeArray = new Node[]{node1, node2};
        Edge[] edgeArray = new Edge[]{edge1, edge2};
        GraphPerspective gp = rootGraph.createGraphPerspective(nodeArray, edgeArray);
        FlagFilter source = new FlagFilter(gp);
        HashSet<Node> nodeSet = new HashSet<Node>();
        nodeSet.add(node1);
        nodeSet.add(node2);
        HashSet<Edge> edgeSet = new HashSet<Edge>();
        edgeSet.add(edge1);
        edgeSet.add(edge2);
        FlagEvent singleNodeOn = new FlagEvent(source, node1, true);
        this.checkEvent(singleNodeOn, source, node1, 0, true);
        FlagEvent singleNodeOff = new FlagEvent(source, node2, false);
        this.checkEvent(singleNodeOff, source, node2, 0, false);
        FlagEvent singleEdgeOn = new FlagEvent(source, edge1, true);
        this.checkEvent(singleEdgeOn, source, edge1, 1, true);
        FlagEvent singleEdgeOff = new FlagEvent(source, edge2, false);
        this.checkEvent(singleEdgeOff, source, edge2, 1, false);
        FlagEvent nodeSetOn = new FlagEvent(source, nodeSet, true);
        this.checkEvent(nodeSetOn, source, nodeSet, 2, true);
        FlagEvent nodeSetOff = new FlagEvent(source, nodeSet, false);
        this.checkEvent(nodeSetOff, source, nodeSet, 2, false);
        FlagEvent edgeSetOn = new FlagEvent(source, edgeSet, true);
        this.checkEvent(edgeSetOn, source, edgeSet, 3, true);
        FlagEvent edgeSetOff = new FlagEvent(source, edgeSet, false);
        this.checkEvent(edgeSetOff, source, edgeSet, 3, false);
    }

    public void checkEvent(FlagEvent event, FlagFilter source, Object target, int targetType, boolean selectOn) {
        FlagEventTest.assertTrue((event.getSource() == source ? 1 : 0) != 0);
        FlagEventTest.assertTrue((event.getTarget() == target ? 1 : 0) != 0);
        FlagEventTest.assertTrue((event.getTargetType() == targetType ? 1 : 0) != 0);
        FlagEventTest.assertTrue((event.getEventType() == selectOn ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(FlagEventTest.class));
    }
}

