/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

public class DatabaseReference {
    private String dbname = null;
    private String dbid = null;

    public DatabaseReference(String dbname, String dbid) {
        if (dbname == null || dbid == null) {
            throw new IllegalArgumentException("DatabaseReference must contain a database name and ID (dbname=" + dbname + "; dbid=" + dbid + ").");
        }
        this.dbname = dbname.toUpperCase();
        this.dbid = dbid.toUpperCase();
    }

    public DatabaseReference(String dbNameID) {
        if (dbNameID == null) {
            throw new IllegalArgumentException("DatabaseReference must contain a database name and ID.");
        }
        String dbName = null;
        String dbID = null;
        String[] dbXrefSplit = dbNameID.split(":");
        if (dbXrefSplit.length != 2) {
            throw new IllegalArgumentException("dbNameID parameter was malformed.  Expected a colon separated string, but found " + dbNameID + ".");
        }
        dbName = dbXrefSplit[0];
        dbID = dbXrefSplit[1];
        this.dbname = dbName.toUpperCase();
        this.dbid = dbID.toUpperCase();
    }

    public String getDbname() {
        return this.dbname;
    }

    public String getDbid() {
        return this.dbid;
    }

    public void setDbname(String dbname) {
        this.dbname = dbname.toUpperCase();
    }

    public void setDbid(String dbid) {
        this.dbid = dbid.toUpperCase();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseReference)) {
            return false;
        }
        DatabaseReference databaseReference = (DatabaseReference)o;
        if (this.dbid != null ? !this.dbid.equals(databaseReference.dbid) : databaseReference.dbid != null) {
            return false;
        }
        return !(this.dbname != null ? !this.dbname.equals(databaseReference.dbname) : databaseReference.dbname != null);
    }

    public int hashCode() {
        int result = this.dbname != null ? this.dbname.hashCode() : 0;
        result = 29 * result + (this.dbid != null ? this.dbid.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDbname() + ":" + this.getDbid());
        return sb.toString();
    }
}

