/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.baderlab.brain.AlignedProteinSequenceIdentityDistance;
import org.baderlab.brain.SimilarityMatrix;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SeqIOTools;

public class AlignedProteinSequenceSimilarity {
    private ArrayList sequences = null;

    public AlignedProteinSequenceSimilarity(String alignedSequencesFileName, String limitToColumns) throws IOException {
        BufferedReader brInterest = new BufferedReader(new FileReader(alignedSequencesFileName));
        try {
            SequenceIterator interestProteins = (SequenceIterator)SeqIOTools.fileToBiojava((String)"fasta", (String)"PROTEIN", (BufferedReader)brInterest);
            this.sequences = new ArrayList();
            while (interestProteins.hasNext()) {
                Sequence sequence = interestProteins.nextSequence();
                if (limitToColumns != null) {
                    String sequenceString = sequence.seqString();
                    StringBuffer sb = new StringBuffer();
                    String[] positions = limitToColumns.split(",");
                    for (int i = 0; i < positions.length; ++i) {
                        String position = positions[i];
                        if (position.indexOf("-") > 0) {
                            String[] startEnd = position.split("-");
                            int start = Integer.parseInt(startEnd[0]);
                            int end = Integer.parseInt(startEnd[1]);
                            sb.append(sequenceString.substring(start - 1, end));
                            continue;
                        }
                        int point = Integer.parseInt(position);
                        sb.append(sequenceString.charAt(point - 1));
                    }
                    this.sequences.add(ProteinTools.createProteinSequence((String)sb.toString(), (String)sequence.getName()));
                    continue;
                }
                this.sequences.add(sequence);
            }
        }
        catch (BioException e) {
            e.printStackTrace();
        }
    }

    private int calculateSimilarity(String sequenceA, String sequenceB) {
        int score = 0;
        SimilarityMatrix simMatrix = new SimilarityMatrix(1);
        for (int i = 0; i < sequenceA.length(); ++i) {
            String aaA = sequenceA.substring(i, i + 1);
            String aaB = sequenceB.substring(i, i + 1);
            if (aaA.equals("-") || aaB.equals("-")) continue;
            score = (int)((double)score + simMatrix.getSimilarityScore(aaA, aaB));
        }
        return score;
    }

    private double calculateSimilarityFactors(String sequenceA, String sequenceB) {
        double score = 0.0;
        SimilarityMatrix simMatrix = new SimilarityMatrix(100);
        for (int i = 0; i < sequenceA.length(); ++i) {
            String aaA = sequenceA.substring(i, i + 1);
            String aaB = sequenceB.substring(i, i + 1);
            if (aaA.equals("-") || aaB.equals("-")) continue;
            double[] factorA = simMatrix.getDrukeFactor(aaA);
            double[] factorB = simMatrix.getDrukeFactor(aaB);
            double distance = 0.0;
            for (int j = 0; j < factorA.length; ++j) {
                double a = factorA[j];
                double b = factorB[j];
                distance += Math.pow(a - b, 2.0);
            }
            score += Math.sqrt(distance);
        }
        return score / (double)sequenceA.length();
    }

    public void calculateSimilarityMatrix() {
        AlignedProteinSequenceIdentityDistance apsid = new AlignedProteinSequenceIdentityDistance();
        for (int i = 0; i < this.sequences.size(); ++i) {
            Sequence protein1 = (Sequence)this.sequences.get(i);
            for (int j = 0; j < this.sequences.size(); ++j) {
                Sequence protein2 = (Sequence)this.sequences.get(j);
                System.out.print(protein1.getName() + "_" + protein2.getName() + "\t");
                System.out.println(apsid.calc(protein1.seqString(), protein2.seqString()));
            }
        }
    }

    public void calculateSimilarityFactorMatrix() {
        for (int i = 0; i < this.sequences.size(); ++i) {
            Sequence protein1 = (Sequence)this.sequences.get(i);
            for (int j = 0; j < this.sequences.size(); ++j) {
                Sequence protein2 = (Sequence)this.sequences.get(j);
                System.out.print(protein1.getName() + "_" + protein2.getName() + "\t");
                System.out.println(this.calculateSimilarityFactors(protein1.seqString(), protein2.seqString()));
            }
        }
    }
}

