/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.baderlab.brain.DatabaseReference;
import org.baderlab.brain.ProteinTerminus;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ChangeVetoException;

public class BindingPeptideList {
    private HashMap nameToPeptide = null;
    private HashMap nameToFreqMap = null;
    private HashMap nameToQuantMap = null;
    private HashMap nameToExtIdMap = null;
    private DatabaseReference protXref = null;
    private ArrayList protXrefList = new ArrayList();
    private String proteinName = null;
    private int domainNumber = 0;
    private DatabaseReference domainXref = null;
    private String domainName = null;
    private String experimentalMethod = null;
    private String domainSequence = null;
    private int domainRangeStart = 0;
    private int domainRangeStop = 0;
    private String comment = null;
    private int minPeptideLength = 0;
    private int maxPeptideLength = 0;
    private String organism;
    private int taxid;
    private HashMap uniquePeptide = null;

    public BindingPeptideList() {
        this.nameToPeptide = new HashMap();
        this.nameToFreqMap = new HashMap();
        this.nameToQuantMap = new HashMap();
        this.nameToExtIdMap = new HashMap();
        this.minPeptideLength = Integer.MAX_VALUE;
    }

    public int getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public int getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public DatabaseReference getProteinXref() {
        return this.protXref;
    }

    public ArrayList getProteinXrefList() {
        return this.protXrefList;
    }

    public String getProteinName() {
        return this.proteinName;
    }

    public int getDomainNumber() {
        return this.domainNumber;
    }

    public DatabaseReference getDomainXref() {
        return this.domainXref;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getExperimentalMethod() {
        return this.experimentalMethod;
    }

    public String getDomainSequence() {
        return this.domainSequence;
    }

    public int getDomainRangeStart() {
        return this.domainRangeStart;
    }

    public int getDomainRangeStop() {
        return this.domainRangeStop;
    }

    public String getOrganism() {
        return this.organism;
    }

    public int getTaxid() {
        return this.taxid;
    }

    public String getComment() {
        return this.comment;
    }

    private void addPeptideToMap(String peptideName, String peptideSequence) throws IllegalSymbolException {
        if (peptideSequence == null || peptideName == null) {
            throw new IllegalArgumentException("addPeptideToMap failed");
        }
        if (this.nameToPeptide.containsKey(peptideName)) {
            System.out.println("Warning: duplicate peptide name found. It will not be added to the profile. (" + peptideName + ")");
        } else {
            this.nameToPeptide.put(peptideName, ProteinTools.createProteinSequence((String)peptideSequence, (String)peptideName));
        }
    }

    private void addPeptideToMap(String peptideName, String peptideSequence, int frequency) throws IllegalSymbolException {
        if (peptideSequence == null || frequency < 1 || peptideName == null) {
            throw new IllegalArgumentException("addPeptideToMap failed");
        }
        if (this.nameToPeptide.containsKey(peptideName)) {
            System.out.println("Warning: duplicate peptide name found. It will not be added to the profile. (" + peptideName + ")");
        } else {
            this.nameToPeptide.put(peptideName, ProteinTools.createProteinSequence((String)peptideSequence, (String)peptideName));
            this.nameToFreqMap.put(peptideName, new Integer(frequency));
        }
    }

    private void addPeptideToMap(String peptideName, String peptideSequence, double quantData) throws IllegalSymbolException {
        if (peptideSequence == null || peptideName == null) {
            throw new IllegalArgumentException("addPeptideToMap failed");
        }
        if (this.nameToPeptide.containsKey(peptideName)) {
            System.out.println("Warning: duplicate peptide name found. It will not be added to the profile. (" + peptideName + ")");
        } else {
            this.nameToPeptide.put(peptideName, ProteinTools.createProteinSequence((String)peptideSequence, (String)peptideName));
            this.nameToQuantMap.put(peptideName, new Double(quantData));
        }
    }

    private void addPeptideToMap(String peptideName, String peptideSequence, String externalId) throws IllegalSymbolException {
        if (peptideSequence == null || peptideName == null) {
            throw new IllegalArgumentException("addPeptideToMap failed");
        }
        if (this.nameToPeptide.containsKey(peptideName)) {
            System.out.println("Warning: duplicate peptide name found. It will not be added to the profile. (" + peptideName + ")");
        } else {
            this.nameToPeptide.put(peptideName, ProteinTools.createProteinSequence((String)peptideSequence, (String)peptideName));
            this.nameToExtIdMap.put(peptideName, externalId);
        }
    }

    private void addPeptideToMap(String peptideName, String peptideSequence, int frequency, double quantData) throws IllegalSymbolException {
        if (peptideSequence == null || frequency < 1 || peptideName == null) {
            throw new IllegalArgumentException("addPeptideToMap failed");
        }
        if (this.nameToPeptide.containsKey(peptideName)) {
            System.out.println("Warning: duplicate peptide name found. It will not be added to the profile. (" + peptideName + ")");
        } else {
            this.nameToPeptide.put(peptideName, ProteinTools.createProteinSequence((String)peptideSequence, (String)peptideName));
            this.nameToFreqMap.put(peptideName, new Integer(frequency));
            this.nameToQuantMap.put(peptideName, new Double(quantData));
        }
    }

    private void addPeptideToMap(String peptideName, String peptideSequence, int frequency, String externalId) throws IllegalSymbolException {
        if (peptideSequence == null || frequency < 1 || peptideName == null) {
            throw new IllegalArgumentException("addPeptideToMap failed");
        }
        if (this.nameToPeptide.containsKey(peptideName)) {
            System.out.println("Warning: duplicate peptide name found. It will not be added to the profile. (" + peptideName + ")");
        } else {
            this.nameToPeptide.put(peptideName, ProteinTools.createProteinSequence((String)peptideSequence, (String)peptideName));
            this.nameToFreqMap.put(peptideName, new Integer(frequency));
            this.nameToExtIdMap.put(peptideName, new String(externalId));
        }
    }

    private void addPeptideToMap(String peptideName, String peptideSequence, double quantData, String externalId) throws IllegalSymbolException {
        if (peptideSequence == null || peptideName == null) {
            throw new IllegalArgumentException("addPeptideToMap failed");
        }
        if (this.nameToPeptide.containsKey(peptideName)) {
            System.out.println("Warning: duplicate peptide name found. It will not be added to the profile. (" + peptideName + ")");
        } else {
            this.nameToPeptide.put(peptideName, ProteinTools.createProteinSequence((String)peptideSequence, (String)peptideName));
            this.nameToQuantMap.put(peptideName, new Double(quantData));
            this.nameToExtIdMap.put(peptideName, new String(externalId));
        }
    }

    private void addPeptideToMap(String peptideName, String peptideSequence, int frequency, double quantData, String externalId) throws IllegalSymbolException {
        if (peptideSequence == null || frequency < 1 || peptideName == null) {
            throw new IllegalArgumentException("addPeptideToMap failed");
        }
        if (this.nameToPeptide.containsKey(peptideName)) {
            System.out.println("Warning: duplicate peptide name found. It will not be added to the profile. (" + peptideName + ")");
        } else {
            this.nameToPeptide.put(peptideName, ProteinTools.createProteinSequence((String)peptideSequence, (String)peptideName));
            this.nameToFreqMap.put(peptideName, new Integer(frequency));
            this.nameToQuantMap.put(peptideName, new Double(quantData));
            this.nameToExtIdMap.put(peptideName, new String(externalId));
        }
    }

    private fileFormat detectFileFormat(String fileName) throws IOException, IllegalSymbolException {
        int lineCount = 0;
        int headerSize = 0;
        int sequenceColumns = 0;
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        String line = null;
        while ((line = br.readLine()) != null) {
            ++lineCount;
            if (line.equals("") || line.charAt(0) == '#') continue;
            String[] lineSplit = line.split("[\t]");
            if (lineSplit.length <= 2) {
                ++headerSize;
                continue;
            }
            sequenceColumns = lineSplit.length;
            break;
        }
        if (headerSize == 9 && sequenceColumns == 3) {
            return fileFormat.one_dot_zero;
        }
        if (headerSize == 11 && sequenceColumns == 5) {
            return fileFormat.one_dot_one;
        }
        throw new RuntimeException("Unable to determine peptide file format version. File format may be invalid. Please check the input file: " + fileName);
    }

    public boolean read(String fileName) throws IOException, IllegalSymbolException {
        fileFormat format = this.detectFileFormat(fileName);
        switch (format) {
            case one_dot_one: {
                return this.readFormat1_1(fileName);
            }
            case one_dot_zero: {
                return this.readFormat1_0(fileName);
            }
        }
        return false;
    }

    private boolean readFormat1_1(String fileName) throws IOException, IllegalSymbolException {
        int lineCount = 0;
        String col1 = null;
        String col2 = null;
        String accession = null;
        boolean header = true;
        String peptideName = null;
        String peptideSequence = null;
        int peptideSequenceLength = 0;
        int frequency = 0;
        double quantData = 0.0;
        String externalId = null;
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        String line = null;
        boolean haveFreq = false;
        boolean haveQuant = false;
        boolean haveExtId = false;
        while ((line = br.readLine()) != null) {
            haveFreq = false;
            haveQuant = false;
            haveExtId = false;
            ++lineCount;
            if (line.equals("") || line.charAt(0) == '#') continue;
            String[] lineSplit = line.split("[\t]", 5);
            if (header) {
                if (lineSplit.length != 2) {
                    throw new RuntimeException("Expected two tab-separated columns. Unable to parse header at line " + lineCount + " (Found: " + line + "). Please check the input file: " + fileName);
                }
                col1 = lineSplit[0];
                col2 = lineSplit[1];
                if (col1.equalsIgnoreCase("Gene Name")) {
                    this.proteinName = col2;
                    continue;
                }
                if (col1.equalsIgnoreCase("Accession")) {
                    if (this.proteinName == null) {
                        throw new RuntimeException("Expected gene name before accession at line " + lineCount + ". Please check the input file: " + fileName);
                    }
                    String[] accessions = col2.split(" ");
                    for (int i = 0; i < accessions.length; ++i) {
                        accession = accessions[i];
                        if (accession.indexOf(":") < 0) {
                            throw new RuntimeException("Expected colon separated accession at line " + lineCount + " (Found: " + col2 + "). Please check the input file: " + fileName);
                        }
                        if (this.protXref == null) {
                            this.protXref = new DatabaseReference(accession);
                            this.protXrefList.add(this.protXref);
                            continue;
                        }
                        this.protXrefList.add(new DatabaseReference(accession));
                    }
                    continue;
                }
                if (col1.equalsIgnoreCase("Organism")) {
                    this.organism = col2;
                    continue;
                }
                if (col1.equalsIgnoreCase("NCBITaxonomyID")) {
                    try {
                        this.taxid = Integer.valueOf(col2);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Unable to find a valid NCBI Taxonomy ID at line " + lineCount + " (Found: " + lineSplit[1] + "). Please check the input file: " + fileName, e);
                    }
                }
                if (col1.equalsIgnoreCase("Domain Number")) {
                    try {
                        this.domainNumber = Integer.valueOf(col2);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Unable to find a valid domain number at line " + lineCount + " (Found: " + lineSplit[1] + "). Please check the input file: " + fileName, e);
                    }
                }
                if (col1.equalsIgnoreCase("Domain Type")) {
                    this.domainName = col2;
                    continue;
                }
                if (col1.equalsIgnoreCase("Interpro ID")) {
                    if (this.proteinName == null) {
                        throw new RuntimeException("Expected domain type before Interpro ID at line " + lineCount + ". Please check the input file: " + fileName);
                    }
                    this.domainXref = new DatabaseReference("Interpro", col2);
                    continue;
                }
                if (col1.equalsIgnoreCase("Technique")) {
                    this.experimentalMethod = col2;
                    continue;
                }
                if (col1.equalsIgnoreCase("Domain sequence")) {
                    this.domainSequence = col2;
                    continue;
                }
                if (col1.equalsIgnoreCase("Domain Range")) {
                    if (col2.length() == 0) continue;
                    if (col2.indexOf("-") < 0) {
                        throw new RuntimeException("Expected dash-separated Domain Range (e.g. 255-300) at line " + lineCount + " (Found: " + lineSplit[1] + "). Please check the input file: " + fileName);
                    }
                    String[] range = col2.split("-");
                    if (range.length != 2) {
                        throw new RuntimeException("Expected domain range format 'start-stop' at line " + lineCount + " (Found: " + lineSplit[1] + "). Please check the input file: " + fileName);
                    }
                    try {
                        this.domainRangeStart = Integer.valueOf(range[0]);
                        this.domainRangeStop = Integer.valueOf(range[1]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Unable to find a valid domain range value at line " + lineCount + " (Found: " + lineSplit[1] + "). Please check the input file: " + fileName, e);
                    }
                }
                if (!col1.equalsIgnoreCase("Comment")) continue;
                if (col2.length() > 0) {
                    this.comment = col2;
                }
                header = false;
                line = br.readLine();
                ++lineCount;
                if (line != null) continue;
                throw new RuntimeException("Expected peptide section header at line " + lineCount + ". Please check the input file: " + fileName);
            }
            if (lineSplit.length >= 2) {
                if (lineSplit[0].length() < 1) {
                    throw new RuntimeException("Expected a value in PeptideName column at line " + lineCount + " (Found: " + lineSplit + "). Please check the input file: " + fileName);
                }
                if (lineSplit[1].length() < 1) {
                    throw new RuntimeException("Expected a value in Peptide column at line " + lineCount + " (Found: " + lineSplit + "). Please check the input file: " + fileName);
                }
                peptideName = lineSplit[0];
                peptideSequence = lineSplit[1];
                if (lineSplit.length > 2 && lineSplit[2].length() > 0) {
                    try {
                        frequency = Integer.parseInt(lineSplit[2]);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Unable to find a valid frequency value at line " + lineCount + " (Found: " + lineSplit[2] + "). Please check the input file: " + fileName, e);
                    }
                    haveFreq = true;
                }
                if (lineSplit.length > 3 && lineSplit[3].length() > 0) {
                    try {
                        quantData = Double.parseDouble(lineSplit[3]);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Unable to read a valid quantitation data value at line " + lineCount + "(Found: " + lineSplit[3] + "). Please check the input file: " + fileName, e);
                    }
                    haveQuant = true;
                }
                if (lineSplit.length > 4 && lineSplit[4].length() > 0) {
                    externalId = lineSplit[4];
                    haveExtId = true;
                }
                try {
                    Integer.parseInt(peptideName);
                    if (haveFreq && haveQuant && haveExtId) {
                        this.addPeptideToMap(peptideName, peptideSequence, frequency, quantData, externalId);
                    } else if (haveFreq && haveQuant) {
                        this.addPeptideToMap(peptideName, peptideSequence, frequency, quantData);
                    } else if (haveFreq && haveExtId) {
                        this.addPeptideToMap(peptideName, peptideSequence, frequency, externalId);
                    } else if (haveQuant && haveExtId) {
                        this.addPeptideToMap(peptideName, peptideSequence, quantData, externalId);
                    } else if (haveFreq) {
                        this.addPeptideToMap(peptideName, peptideSequence, frequency);
                    } else if (haveQuant) {
                        this.addPeptideToMap(peptideName, peptideSequence, quantData);
                    } else if (haveExtId) {
                        this.addPeptideToMap(peptideName, peptideSequence, externalId);
                    } else {
                        this.addPeptideToMap(peptideName, peptideSequence);
                    }
                    peptideSequenceLength = peptideSequence.length();
                    if (this.minPeptideLength > peptideSequenceLength) {
                        this.minPeptideLength = peptideSequenceLength;
                    }
                    if (this.maxPeptideLength >= peptideSequenceLength) continue;
                    this.maxPeptideLength = peptideSequenceLength;
                }
                catch (NumberFormatException e) {}
                continue;
            }
            throw new RuntimeException("Line number: " + lineCount + " is not valid. (" + line + ")");
        }
        br.close();
        return true;
    }

    private boolean readFormat1_0(String fileName) throws IOException, IllegalSymbolException {
        int lineCount = 0;
        String col1 = null;
        String col2 = null;
        String accession = null;
        boolean header = true;
        String peptideName = null;
        String peptideSequence = null;
        int peptideSequenceLength = 0;
        int frequency = 0;
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        String line = null;
        while ((line = br.readLine()) != null) {
            ++lineCount;
            if (line.equals("") || line.charAt(0) == '#') continue;
            String[] lineSplit = line.split("[\t]");
            if (header) {
                if (lineSplit.length != 2) {
                    throw new RuntimeException("Expected two tab-separated columns. Unable to parse header at line " + lineCount + " (Found: " + line + "). Please check the input file: " + fileName);
                }
                col1 = lineSplit[0];
                col2 = lineSplit[1];
                if (col1.equalsIgnoreCase("Gene Name")) {
                    this.proteinName = col2;
                    continue;
                }
                if (col1.equalsIgnoreCase("Accession")) {
                    if (this.proteinName == null) {
                        throw new RuntimeException("Expected gene name before accession at line " + lineCount + ". Please check the input file: " + fileName);
                    }
                    accession = col2;
                    this.protXref = new DatabaseReference(accession);
                    continue;
                }
                if (col1.equalsIgnoreCase("Organism")) {
                    this.organism = col2;
                    continue;
                }
                if (col1.equalsIgnoreCase("NCBITaxonomyID")) {
                    try {
                        this.taxid = Integer.valueOf(col2);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Unable to find a valid NCBI Taxonomy ID at line " + lineCount + " (Found: " + lineSplit[1] + "). Please check the input file: " + fileName, e);
                    }
                }
                if (col1.equalsIgnoreCase("Domain Number")) {
                    try {
                        this.domainNumber = Integer.valueOf(col2);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Unable to find a valid domain number at line " + lineCount + " (Found: " + lineSplit[1] + "). Please check the input file: " + fileName, e);
                    }
                }
                if (col1.equalsIgnoreCase("Domain Type")) {
                    this.domainName = col2;
                    continue;
                }
                if (col1.equalsIgnoreCase("Interpro ID")) {
                    if (this.proteinName == null) {
                        throw new RuntimeException("Expected domain type before Interpro ID at line " + lineCount + ". Please check the input file: " + fileName);
                    }
                    this.domainXref = new DatabaseReference("Interpro", col2);
                    continue;
                }
                if (col1.equalsIgnoreCase("Technique")) {
                    this.experimentalMethod = col2;
                    continue;
                }
                if (!col1.equalsIgnoreCase("Domain sequence")) continue;
                this.domainSequence = col2;
                header = false;
                line = br.readLine();
                ++lineCount;
                if (line != null) continue;
                throw new RuntimeException("Expected peptide section header at line " + lineCount + ". Please check the input file: " + fileName);
            }
            if (lineSplit.length == 3) {
                peptideName = lineSplit[0];
                peptideSequence = lineSplit[1];
                try {
                    frequency = Integer.parseInt(lineSplit[2]);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Unable to find a valid frequency value at line " + lineCount + " (Found: " + lineSplit[2] + "). Please check the input file: " + fileName, e);
                }
                try {
                    Integer.parseInt(peptideName);
                    this.addPeptideToMap(peptideName, peptideSequence, frequency);
                    peptideSequenceLength = peptideSequence.length();
                    if (this.minPeptideLength > peptideSequenceLength) {
                        this.minPeptideLength = peptideSequenceLength;
                    }
                    if (this.maxPeptideLength >= peptideSequenceLength) continue;
                    this.maxPeptideLength = peptideSequenceLength;
                }
                catch (NumberFormatException e) {}
                continue;
            }
            throw new RuntimeException("Line number: " + lineCount + " is not valid. (" + line + ")");
        }
        br.close();
        return true;
    }

    private boolean isUniquePeptide(String peptide) {
        if (this.uniquePeptide == null) {
            this.uniquePeptide = new HashMap();
        }
        if (this.uniquePeptide.containsKey(peptide)) {
            return false;
        }
        this.uniquePeptide.put(peptide, peptide);
        return true;
    }

    public SequenceIterator getSequenceIteratorByLength(int length, ProteinTerminus terminus) {
        return this.getSequenceIteratorByLength(length, terminus, false, false);
    }

    public SequenceIterator getSequenceIteratorByLength(int length, ProteinTerminus terminus, boolean frequencyExpansion, boolean unique) {
        if (length < 1 || length > this.maxPeptideLength) {
            throw new IllegalArgumentException("Length " + length + " is invalid. Must be between 1 and " + this.maxPeptideLength + ".");
        }
        if (length < this.maxPeptideLength && terminus != ProteinTerminus.C && terminus != ProteinTerminus.N) {
            throw new IllegalArgumentException("You must provide a terminus if peptides will be truncated.");
        }
        HashSequenceDB searchDB = new HashSequenceDB();
        Set peptideNames = this.nameToPeptide.keySet();
        Object peptideToAdd = null;
        for (String peptideName : peptideNames) {
            Sequence peptide = (Sequence)this.nameToPeptide.get(peptideName);
            int peptideLength = peptide.length();
            if (peptideLength > length) {
                if (terminus == ProteinTerminus.C) {
                    peptideToAdd = peptide.subList(peptideLength - length + 1, peptideLength);
                } else if (terminus == ProteinTerminus.N) {
                    peptideToAdd = peptide.subList(1, length);
                }
            } else {
                peptideToAdd = peptideLength == length ? peptide : null;
            }
            try {
                if (peptideToAdd == null) continue;
                if (frequencyExpansion) {
                    int frequency = (Integer)this.nameToFreqMap.get(peptideName);
                    for (int i = 0; i < frequency; ++i) {
                        searchDB.addSequence(ProteinTools.createProteinSequence((String)peptideToAdd.seqString(), (String)(peptide.getName() + "_" + i)));
                    }
                    continue;
                }
                if (unique) {
                    if (!this.isUniquePeptide(peptideToAdd.seqString())) continue;
                    searchDB.addSequence(ProteinTools.createProteinSequence((String)peptideToAdd.seqString(), (String)peptide.getName()));
                    continue;
                }
                searchDB.addSequence(ProteinTools.createProteinSequence((String)peptideToAdd.seqString(), (String)peptide.getName()));
            }
            catch (ChangeVetoException e) {
                e.printStackTrace();
            }
            catch (IllegalIDException e) {
                e.printStackTrace();
            }
            catch (BioException e) {
                e.printStackTrace();
            }
        }
        return searchDB.sequenceIterator();
    }

    public SequenceIterator getSequenceIterator() {
        return this.getSequenceIteratorByLength(this.getMaxPeptideLength(), ProteinTerminus.NONE, false, false);
    }

    public SequenceIterator getSequenceIterator(boolean frequencyExpansion) {
        return this.getSequenceIteratorByLength(this.getMaxPeptideLength(), ProteinTerminus.NONE, frequencyExpansion, false);
    }

    public SequenceIterator getSequenceIterator(boolean frequencyExpansion, boolean unique) {
        return this.getSequenceIteratorByLength(this.getMaxPeptideLength(), ProteinTerminus.NONE, frequencyExpansion, unique);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum fileFormat {
        one_dot_zero,
        one_dot_one;

    }
}

