/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import org.baderlab.brain.ChargedProteinLogoStyle;
import org.baderlab.brain.HydrophobicBySizeProteinLogoStyle;
import org.baderlab.brain.HydroxylProteinLogoStyle;
import org.baderlab.brain.PDZProteinLogoStyle;
import org.baderlab.brain.WebLogoProteinStyle;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.Symbol;

public class AminoAcidGrouping {
    public static final String GROUPING_NO_GROUPING = "No Grouping";
    public static final String GROUPING_POLAR_CHARGED = "Polar-Hydrophobic";
    public static final String GROUPING_HYDROPHOBIC = "Hydrophobic-Size";
    public static final String GROUPING_HYDROXYL = "Hydroxyl+";
    public static final String GROUPING_PDZ = "PDZ";
    public static final String GROUPING_WEBLOGO = "WebLogo";
    public static final String GROUPING_DEFAULT = "No Grouping";
    public static final String COLORING_POLAR_CHARGED = "Polar-Hydrophobic";
    public static final String COLORING_HYDROPHOBIC = "Hydrophobic-Size";
    public static final String COLORING_HYDROXYL = "Hydroxyl+";
    public static final String COLORING_PDZ = "PDZ";
    public static final String COLORING_WEBLOGO = "WebLogo";
    public static final String COLORING_DEFAULT = "WebLogo";
    public static final String DESCRIPTION_NO_GROUPING = "No amino acid grouping applied";
    public static final String DESCRIPTION_POLAR_CHARGED = "Grouped by polarity and charge; hydrophobic residues are grouped separately";
    public static final String DESCRIPTION_HYDROPHOBIC = "Grouped by hydrophobicity and size";
    public static final String DESCRIPTION_HYDROXYL = "Grouped by common physico-chemical properties";
    public static final String DESCRIPTION_WEBLOGO = "WebLogo default grouping scheme";
    public static final String DESCRIPTION_PDZ = "Grouping based on PDZ 2007 meeting";
    public static final String[] GROUPING_METHODS = new String[]{"No Grouping", "Polar-Hydrophobic", "Hydrophobic-Size", "Hydroxyl+", "PDZ", "WebLogo"};
    public static final String[] COLORING_METHODS = new String[]{"Polar-Hydrophobic", "Hydrophobic-Size", "Hydroxyl+", "PDZ", "WebLogo"};
    private static final int[][] RGB_POLAR_CHARGED = new int[][]{{255, 4, 255}, {204, 2, 4}, {4, 2, 204}, {91, 91, 91}, {102, 0, 102}, {255, 170, 0}, {102, 51, 0}, {0, 0, 0}};
    private static final int[][] RGB_HYDROPHOBIC = new int[][]{{200, 200, 200}, {4, 2, 255}, {4, 2, 204}, {50, 50, 255}, {60, 80, 255}, {150, 150, 150}, {91, 91, 91}, {0, 0, 0}};
    private static final int[][] RGB_HYDROXYL = new int[][]{{255, 4, 255}, {4, 2, 204}, {204, 2, 4}, {91, 91, 91}, {0, 0, 0}};
    private static final int[][] RGB_PDZ = new int[][]{{4, 206, 4}, {204, 2, 4}, {4, 2, 204}, {102, 0, 102}, {255, 170, 0}, {102, 51, 0}, {0, 0, 0}};
    private static final int[][] RGB_WEBLOGO = new int[][]{{4, 206, 4}, {204, 2, 4}, {4, 2, 204}, {0, 0, 0}};
    private static final String[] GROUPS_POLAR_CHARGED = new String[]{"STQN", "KRH", "DE", "C", "P", "G", "LAMIVFWY"};
    private static final String[] GROUPS_HYDROPHOBIC = new String[]{"ST", "KRH", "DEQN", "G", "P", "VAC", "ILM", "FWY"};
    private static final String[] GROUPS_HYDROXYL = new String[]{"ST", "KRH", "DEQN", "G", "FLAMPWIVCY"};
    private static final String[] GROUPS_PDZ = new String[]{"STQN", "DE", "KRH", "G", "C", "P", "AVLIMFYW"};
    private static final String[] GROUPS_WEBLOGO = new String[]{"GSTYCQN", "DE", "KRH", "AVLIPWFM"};
    private static final String[] COLORS_POLAR_CHARGED = GROUPS_POLAR_CHARGED;
    private static final String[] COLORS_HYDROPHOBIC = GROUPS_HYDROPHOBIC;
    private static final String[] COLORS_HYDROXYL = GROUPS_HYDROXYL;
    private static final String[] COLORS_PDZ = GROUPS_PDZ;
    private static final String[] COLORS_WEBLOGO = GROUPS_WEBLOGO;
    private static final String[] COLOR_CATEGORIES_POLAR_CHARGED = new String[]{"Polar Neutral", "Polar Positive", "Polar Negative", "Non-Polar Tiny", "Non-Polar Small", "Non-Polar Small", "Hydrophobic"};
    private static final String[] COLOR_CATEGORIES_HYDROPHOBIC = new String[]{"Hydrophobic-Small", "Hydrophilic-Large", "Hydrophilic-Small", "Hydrophilic-Tiny", "Small", "Hydrophobic-Small (Polar)", "Hydrophobic-Medium (Non-polar)", "Hydrophobic-Large"};
    private static final String[] COLOR_CATEGORIES_HYDROXYL = new String[]{"Hydroxyl-Polar", "Basic", "Polar-Acidic", "Hydrophilic-Nonpolar", "Hydrophobic"};
    private static final String[] COLOR_CATEGORIES_PDZ = new String[]{"Polar", "Acidic", "Basic", "Tiny", "Small", "Small", "Hydrophobic"};
    private static final String[] COLOR_CATEGORIES_WEBLOGO = new String[]{"Polar", "Acidic", "Basic", "Hydrophobic"};
    private static final String[] GROUP_CATEGORIES_POLAR_CHARGED = COLOR_CATEGORIES_POLAR_CHARGED;
    private static final String[] GROUP_CATEGORIES_HYDROPHOBIC = COLOR_CATEGORIES_HYDROPHOBIC;
    private static final String[] GROUP_CATEGORIES_HYDROXYL = COLOR_CATEGORIES_HYDROXYL;
    private static final String[] GROUP_CATEGORIES_PDZ = COLOR_CATEGORIES_PDZ;
    private static final String[] GROUP_CATEGORIES_WEBLOGO = COLOR_CATEGORIES_WEBLOGO;
    private String selectedGrouping;
    private String selectedColoring;
    private String selectedDescription;
    private String selectedGroups;
    private ArrayList<Color> colorList = new ArrayList();
    private ArrayList<String> colorSymbolList = new ArrayList();
    private ArrayList<String> colorCategoryList = new ArrayList();
    private ArrayList<String> groupList = new ArrayList();
    private ArrayList<String> groupCategoryList = new ArrayList();
    private SymbolStyle proteinLogoStyle;
    private int numberOfGroups = 0;
    private int numberOfColors = 0;

    public AminoAcidGrouping() {
        this.setGrouping("No Grouping");
        this.setColoring("WebLogo");
    }

    public void setColoring(String colorType) {
        this.selectedColoring = colorType;
        this.colorList.clear();
        this.colorSymbolList.clear();
        this.colorCategoryList.clear();
        if (colorType == "Polar-Hydrophobic") {
            this.proteinLogoStyle = new ChargedProteinLogoStyle(this.colorList);
            this.numberOfColors = COLORS_POLAR_CHARGED.length;
            this.selectedDescription = DESCRIPTION_POLAR_CHARGED;
            for (int i = 0; i < this.numberOfColors; ++i) {
                this.colorList.add(new Color(RGB_POLAR_CHARGED[i][0], RGB_POLAR_CHARGED[i][1], RGB_POLAR_CHARGED[i][2]));
                this.colorSymbolList.add(COLORS_POLAR_CHARGED[i]);
                this.colorCategoryList.add(COLOR_CATEGORIES_POLAR_CHARGED[i]);
            }
        } else if (colorType == "Hydrophobic-Size") {
            this.proteinLogoStyle = new HydrophobicBySizeProteinLogoStyle(this.colorList);
            this.numberOfColors = COLORS_HYDROPHOBIC.length;
            this.selectedDescription = DESCRIPTION_HYDROPHOBIC;
            for (int i = 0; i < this.numberOfColors; ++i) {
                this.colorList.add(new Color(RGB_HYDROPHOBIC[i][0], RGB_HYDROPHOBIC[i][1], RGB_HYDROPHOBIC[i][2]));
                this.colorSymbolList.add(COLORS_HYDROPHOBIC[i]);
                this.colorCategoryList.add(COLOR_CATEGORIES_HYDROPHOBIC[i]);
            }
        } else if (colorType == "Hydroxyl+") {
            this.proteinLogoStyle = new HydroxylProteinLogoStyle(this.colorList);
            this.numberOfColors = COLORS_HYDROXYL.length;
            this.selectedDescription = DESCRIPTION_HYDROXYL;
            for (int i = 0; i < this.numberOfColors; ++i) {
                this.colorList.add(new Color(RGB_HYDROXYL[i][0], RGB_HYDROXYL[i][1], RGB_HYDROXYL[i][2]));
                this.colorSymbolList.add(COLORS_HYDROXYL[i]);
                this.colorCategoryList.add(COLOR_CATEGORIES_HYDROXYL[i]);
            }
        } else if (colorType == "PDZ") {
            this.proteinLogoStyle = new PDZProteinLogoStyle(this.colorList);
            this.numberOfColors = COLORS_PDZ.length;
            this.selectedDescription = DESCRIPTION_PDZ;
            for (int i = 0; i < this.numberOfColors; ++i) {
                this.colorList.add(new Color(RGB_PDZ[i][0], RGB_PDZ[i][1], RGB_PDZ[i][2]));
                this.colorSymbolList.add(COLORS_PDZ[i]);
                this.colorCategoryList.add(COLOR_CATEGORIES_PDZ[i]);
            }
        } else if (colorType == "WebLogo") {
            this.proteinLogoStyle = new WebLogoProteinStyle(this);
            this.numberOfColors = COLORS_WEBLOGO.length;
            this.selectedDescription = DESCRIPTION_WEBLOGO;
            for (int i = 0; i < this.numberOfColors; ++i) {
                this.colorList.add(new Color(RGB_WEBLOGO[i][0], RGB_WEBLOGO[i][1], RGB_WEBLOGO[i][2]));
                this.colorSymbolList.add(COLORS_WEBLOGO[i]);
                this.colorCategoryList.add(COLOR_CATEGORIES_WEBLOGO[i]);
            }
        } else {
            throw new IllegalStateException("'" + colorType + "' is not a recognized color scheme.");
        }
    }

    public void setGrouping(String groupType) {
        block6: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                this.selectedGrouping = groupType;
                                this.groupList.clear();
                                this.groupCategoryList.clear();
                                if (groupType != "No Grouping") break block5;
                                this.selectedDescription = DESCRIPTION_NO_GROUPING;
                                this.selectedGroups = null;
                                this.numberOfGroups = 0;
                                break block6;
                            }
                            if (groupType != "Polar-Hydrophobic") break block7;
                            this.selectedDescription = DESCRIPTION_POLAR_CHARGED;
                            this.selectedGroups = Arrays.toString(GROUPS_POLAR_CHARGED);
                            this.numberOfGroups = GROUPS_POLAR_CHARGED.length;
                            for (int i = 0; i < this.numberOfGroups; ++i) {
                                this.groupList.add(GROUPS_POLAR_CHARGED[i]);
                                this.groupCategoryList.add(GROUP_CATEGORIES_POLAR_CHARGED[i]);
                            }
                            break block6;
                        }
                        if (groupType != "Hydrophobic-Size") break block8;
                        this.selectedDescription = DESCRIPTION_HYDROPHOBIC;
                        this.selectedGroups = Arrays.toString(GROUPS_HYDROPHOBIC);
                        this.numberOfGroups = GROUPS_HYDROPHOBIC.length;
                        for (int i = 0; i < this.numberOfGroups; ++i) {
                            this.groupList.add(GROUPS_HYDROPHOBIC[i]);
                            this.groupCategoryList.add(GROUP_CATEGORIES_HYDROPHOBIC[i]);
                        }
                        break block6;
                    }
                    if (groupType != "Hydroxyl+") break block9;
                    this.selectedDescription = DESCRIPTION_HYDROXYL;
                    this.selectedGroups = Arrays.toString(GROUPS_HYDROXYL);
                    this.numberOfGroups = GROUPS_HYDROXYL.length;
                    for (int i = 0; i < this.numberOfGroups; ++i) {
                        this.groupList.add(GROUPS_HYDROXYL[i]);
                        this.groupCategoryList.add(GROUP_CATEGORIES_HYDROXYL[i]);
                    }
                    break block6;
                }
                if (groupType != "PDZ") break block10;
                this.selectedDescription = DESCRIPTION_PDZ;
                this.selectedGroups = Arrays.toString(GROUPS_PDZ);
                this.numberOfGroups = GROUPS_PDZ.length;
                for (int i = 0; i < this.numberOfGroups; ++i) {
                    this.groupList.add(GROUPS_PDZ[i]);
                    this.groupCategoryList.add(GROUP_CATEGORIES_PDZ[i]);
                }
                break block6;
            }
            if (groupType != "WebLogo") break block6;
            this.selectedDescription = DESCRIPTION_WEBLOGO;
            this.selectedGroups = Arrays.toString(GROUPS_WEBLOGO);
            this.numberOfGroups = GROUPS_WEBLOGO.length;
            for (int i = 0; i < this.numberOfGroups; ++i) {
                this.groupList.add(GROUPS_WEBLOGO[i]);
                this.groupCategoryList.add(GROUP_CATEGORIES_WEBLOGO[i]);
            }
        }
    }

    public ArrayList getColorList() {
        return this.colorList;
    }

    public ArrayList getColorSymbolList() {
        return this.colorSymbolList;
    }

    public ArrayList getGroupList() {
        return this.groupList;
    }

    public ArrayList getColorCategoryList() {
        return this.colorCategoryList;
    }

    public ArrayList getGroupCategoryList() {
        return this.groupCategoryList;
    }

    public SymbolStyle getProteinLogoStyle() {
        return new WebLogoProteinStyle(this);
    }

    public int getNumberOfGroups() {
        return this.numberOfGroups;
    }

    public int getNumberOfColors() {
        return this.numberOfColors;
    }

    public String getSelectedColoring() {
        return this.selectedColoring;
    }

    public String getSelectedGrouping() {
        return this.selectedGrouping;
    }

    public String getSelectedDescription() {
        return this.selectedDescription;
    }

    public String getSelectedGroups() {
        return this.selectedGroups;
    }

    public void addColor(Color color, String symbols, String category) {
        this.colorList.add(color);
        this.colorSymbolList.add(symbols);
        this.colorCategoryList.add(category);
        ++this.numberOfColors;
    }

    public void removeColor(int index) {
        this.colorList.remove(index);
        this.colorSymbolList.remove(index);
        this.colorCategoryList.remove(index);
        --this.numberOfColors;
    }

    public void setColorSymbols(int index, String symbols) {
        if (symbols == null) {
            throw new IllegalArgumentException("Symbol parameter must be non-null.");
        }
        if (index > this.colorSymbolList.size() - 1) {
            throw new IllegalArgumentException("Index parameter is out of range.");
        }
        this.colorSymbolList.set(index, symbols);
    }

    public void setColor(int index, Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Color parameter must be non-null.");
        }
        if (index > this.colorList.size() - 1) {
            throw new IllegalArgumentException("Index parameter is out of range.");
        }
        this.colorList.set(index, color);
    }

    public Color getColor(Symbol symbol) {
        String residue = this.getSymbolString(symbol);
        Color color = null;
        for (int i = 0; i < this.colorSymbolList.size(); ++i) {
            String symbols = this.colorSymbolList.get(i);
            if (symbols == null) {
                System.out.println("This should not happen!!");
            }
            if (residue == null) {
                System.out.println("This should also not happen!!!");
            }
            if (!symbols.contains(residue)) continue;
            color = this.colorList.get(i);
        }
        return color;
    }

    private String getSymbolString(Symbol s) {
        if (s.equals(ProteinTools.a())) {
            return "A";
        }
        if (s.equals(ProteinTools.c())) {
            return "C";
        }
        if (s.equals(ProteinTools.d())) {
            return "D";
        }
        if (s.equals(ProteinTools.e())) {
            return "E";
        }
        if (s.equals(ProteinTools.f())) {
            return "F";
        }
        if (s.equals(ProteinTools.g())) {
            return "G";
        }
        if (s.equals(ProteinTools.h())) {
            return "h";
        }
        if (s.equals(ProteinTools.i())) {
            return "I";
        }
        if (s.equals(ProteinTools.k())) {
            return "K";
        }
        if (s.equals(ProteinTools.l())) {
            return "L";
        }
        if (s.equals(ProteinTools.m())) {
            return "M";
        }
        if (s.equals(ProteinTools.n())) {
            return "N";
        }
        if (s.equals(ProteinTools.p())) {
            return "P";
        }
        if (s.equals(ProteinTools.q())) {
            return "Q";
        }
        if (s.equals(ProteinTools.r())) {
            return "R";
        }
        if (s.equals(ProteinTools.s())) {
            return "S";
        }
        if (s.equals(ProteinTools.t())) {
            return "T";
        }
        if (s.equals(ProteinTools.u())) {
            return "U";
        }
        if (s.equals(ProteinTools.v())) {
            return "V";
        }
        if (s.equals(ProteinTools.w())) {
            return "W";
        }
        if (s.equals(ProteinTools.y())) {
            return "Y";
        }
        if (s.equals(ProteinTools.ter())) {
            return "*";
        }
        return null;
    }

    public static String getHydroxylBasicAcidicpolarHydrophobeGrouping() {
        return Arrays.toString(GROUPS_HYDROXYL);
    }

    public static String getPolarChargedHydrophobeGrouping() {
        return Arrays.toString(GROUPS_POLAR_CHARGED);
    }

    public static String getGroupingHydrophobeBySize() {
        return Arrays.toString(GROUPS_HYDROPHOBIC);
    }

    public static String getWebLogo() {
        return Arrays.toString(GROUPS_WEBLOGO);
    }

    public static String getPDZ() {
        return Arrays.toString(GROUPS_PDZ);
    }

    public static String[] getPositionSpecificPDZGrouping() {
        String[] groupingByPosition = new String[]{"ST, KRH, DEQN, FLAMPWIVCY, G", "ST, KRH, DEQN, MPVCYFWLIA, G", "ST, KRH, DEQN, FLAMPIVCY, G, W", "ST, KRH, DEQN, G, P, VAC, ILM, FWY"};
        return groupingByPosition;
    }
}

