/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freehep.application.mdi.CloseButtonTabbedPane;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;

public class TabbedPageManager
extends PageManager {
    protected JTabbedPane tabs;
    private ChangeListener cl;
    private int tabPlacement = 1;

    public TabbedPageManager() {
        this.setPageManagerType("Tab");
    }

    public void setTabPlacement(int placement) {
        this.tabPlacement = placement;
        if (this.tabs != null) {
            this.tabs.setTabPlacement(placement);
        }
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    protected void show(PageContext page) {
        this.tabs.setSelectedComponent(page.getPage());
    }

    protected Component getEmbodiment() {
        return this.tabs;
    }

    protected boolean close(PageContext page) {
        boolean ok = super.close(page);
        if (ok) {
            this.tabs.removeTabAt(this.indexOfPage(page));
        }
        this.cl.stateChanged(new ChangeEvent(this));
        return ok;
    }

    private String hackedTitle(String title) {
        return title == null ? CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE : String.valueOf(title) + CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE;
    }

    protected void titleChanged(PageContext page) {
        this.tabs.setTitleAt(this.indexOfPage(page), this.hackedTitle(page.getTitle()));
    }

    protected void iconChanged(PageContext page) {
        this.tabs.setIconAt(this.indexOfPage(page), page.getIcon());
    }

    protected int indexOfPage(PageContext page) {
        return this.tabs.indexOfComponent(page.getPage());
    }

    public PageContext openPage(Component c, String title, Icon icon, String type) {
        PageContext context = super.openPage(c, title, icon, type);
        this.tabs.addTab(this.hackedTitle(title), icon, c);
        super.firePageOpened(context);
        this.tabs.setSelectedComponent(c);
        return context;
    }

    protected void init(List pages, PageContext selected) {
        this.tabs.removeChangeListener(this.cl);
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            PageContext context = (PageContext)i.next();
            this.tabs.addTab(this.hackedTitle(context.getTitle()), context.getIcon(), context.getPage());
            if (context != selected) continue;
            this.tabs.setSelectedComponent(context.getPage());
        }
        super.init(pages, selected);
        this.tabs.addChangeListener(this.cl);
        if (selected == null && pages.size() > 0) {
            this.fireSelectionChanged((PageContext)this.pages().get(this.tabs.getSelectedIndex()));
        }
    }

    public PageContext getSelectedPage() {
        PageContext selected = super.getSelectedPage();
        if (selected != null) {
            return selected;
        }
        int selectedIndex = this.tabs.getSelectedIndex();
        if (selectedIndex < 0) {
            return null;
        }
        return (PageContext)this.pages().get(selectedIndex);
    }

    protected void setActive(boolean active) {
        if (active) {
            this.tabs = new CloseButtonTabbedPane(){

                protected void fireCloseTabAt(int index) {
                    TabbedPageManager.this.close((PageContext)TabbedPageManager.this.pages().get(index));
                }

                public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
                    return TabbedPageManager.this.modifyPopupMenu(menu, source, p);
                }
            };
            this.tabs.setTabPlacement(this.tabPlacement);
            this.cl = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    int index = TabbedPageManager.this.tabs.getSelectedIndex();
                    if (index != -1) {
                        TabbedPageManager.this.fireSelectionChanged((PageContext)TabbedPageManager.this.pages().get(index));
                    }
                }
            };
            this.tabs.addChangeListener(this.cl);
        } else {
            this.tabs.removeAll();
            this.tabs.removeChangeListener(this.cl);
            this.tabs = null;
        }
    }
}

