/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.lola.view.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import org.baderlab.brain.BrainAlgorithm;
import org.baderlab.brain.LogoTreeDraw;
import org.baderlab.brain.ProfileSearchProjectFile;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.lola.model.LogoTree;
import org.baderlab.lola.model.ProfileSet;

public class MakeLogoTreeAction
implements ActionListener {
    private ProfileSet profileSet;
    LolaParameterSet paramSet;

    public MakeLogoTreeAction(ProfileSet profileSet, LolaParameterSet params) {
        this.profileSet = profileSet;
        this.paramSet = params;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean isProjectFile = false;
        ProfileSearchProjectFile profileProjectFile = new ProfileSearchProjectFile();
        try {
            if (profileProjectFile.isProjectFile(this.paramSet.getProfileFile().toString())) {
                isProjectFile = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (isProjectFile) {
            BrainAlgorithm alg = new BrainAlgorithm();
            String outputPath = this.paramSet.getOutputPath() + File.separator + this.paramSet.getTreeFilename();
            System.out.println("Generating logo tree for profile " + this.paramSet.getProfileFile().toString());
            LogoTreeDraw ltd = alg.runAlignedProfileCluster(this.paramSet.getProfileFile().toString(), this.paramSet.getTreeTitle(), new File(outputPath), this.paramSet.getTreeLeafTrimFactor(), this.paramSet.getTreeInternalNodeTrimFactor(), this.paramSet.getTreeLeafOrderingMethod(), this.paramSet.getAminoAcidGrouping(), false);
            LogoTree tree = new LogoTree();
            tree.setOutputFilePath(outputPath);
            tree.setIsSaved(false);
            tree.setLogoTreeDraw(ltd);
            tree.setImage(ltd.outputToGraphics());
            this.profileSet.setLogoTree(tree);
        }
    }
}

