/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.lola.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import org.baderlab.brain.PeptideToProfileReader;
import org.baderlab.brain.ProfileSearchProjectFile;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.lola.model.LogoGenerator;
import org.baderlab.lola.model.Profile;
import org.baderlab.lola.model.ProfileSet;

public class MakeLogosFromProfileSetAction
implements ActionListener {
    private ProfileSet profileSet;
    LolaParameterSet paramSet;

    public MakeLogosFromProfileSetAction(ProfileSet profileSet, LolaParameterSet params) {
        this.profileSet = profileSet;
        this.paramSet = params;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean isProjectFile = false;
        ProfileSearchProjectFile profileProjectFile = new ProfileSearchProjectFile();
        try {
            if (profileProjectFile.isProjectFile(this.paramSet.getProfileFile().toString())) {
                isProjectFile = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(this.paramSet.getProfileFile(), this.paramSet.getFuzzFactor(), this.paramSet.getCodonBiasFile(), this.paramSet.getUniquePeptides());
        this.profileSet.clear();
        for (int i = 0; i < profileList.size(); ++i) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            BufferedImage image = LogoGenerator.generateImage(proteinProfile, this.paramSet, "_logo");
            Profile profile = new Profile();
            profile.set(proteinProfile);
            profile.setImage(image);
            this.profileSet.addElement(profile);
        }
    }
}

