/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.parsers;

import cytoscape.visual.Arrow;
import cytoscape.visual.LabelPosition;
import cytoscape.visual.LineType;
import cytoscape.visual.parsers.ArrowParser;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.parsers.DoubleParser;
import cytoscape.visual.parsers.FontParser;
import cytoscape.visual.parsers.LabelPositionParser;
import cytoscape.visual.parsers.LineTypeParser;
import cytoscape.visual.parsers.NodeShapeParser;
import cytoscape.visual.parsers.StringParser;
import cytoscape.visual.parsers.ValueParser;
import java.awt.Color;
import java.awt.Font;

public class ParserFactory {
    public static ValueParser getParser(Object o) {
        return ParserFactory.getParser(o.getClass());
    }

    public static ValueParser getParser(Class c) {
        ValueParser parser = null;
        if (c.isAssignableFrom(String.class)) {
            parser = new StringParser();
        } else if (c.isAssignableFrom(Font.class)) {
            parser = new FontParser();
        } else if (c.isAssignableFrom(Double.class)) {
            parser = new DoubleParser();
        } else if (c.isAssignableFrom(Arrow.class)) {
            parser = new ArrowParser();
        } else if (c.isAssignableFrom(LineType.class)) {
            parser = new LineTypeParser();
        } else if (c.isAssignableFrom(Byte.class)) {
            parser = new NodeShapeParser();
        } else if (c.isAssignableFrom(LabelPosition.class)) {
            parser = new LabelPositionParser();
        } else if (c.isAssignableFrom(Color.class)) {
            parser = new ColorParser();
        } else {
            System.err.println("couldn't construct parser for class: " + c.toString());
        }
        return parser;
    }
}

