/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.data.readers.TextJarReader;
import java.io.IOException;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TextJarReaderTest
extends TestCase {
    public TextJarReaderTest(String name) {
        super(name);
    }

    public void testOldSchool() throws Exception {
        TextJarReader reader = new TextJarReader("jar://vizmap.props");
        int count = reader.read();
        String text = reader.getText();
        TextJarReaderTest.assertTrue((text.length() > 0 ? 1 : 0) != 0);
    }

    public void testNewSchool() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("/vizmap.props");
        System.out.println("url: " + url.toString());
        if (url.toString().startsWith("file")) {
            try {
                TextJarReader reader = new TextJarReader(url.toString());
            }
            catch (IOException e) {
                System.out.println("We expect the following error since TextJarReader only supports jar urls.");
                e.printStackTrace();
                TextJarReaderTest.assertTrue((boolean)true);
                return;
            }
            TextJarReaderTest.fail((String)"didn't catch expected exception");
        } else {
            TextJarReader reader = new TextJarReader(url.toString());
            int count = reader.read();
            String text = reader.getText();
            System.out.println(text);
            TextJarReaderTest.assertTrue((text.length() > 0 ? 1 : 0) != 0);
        }
    }

    public void testBadURL() throws Exception {
        URL url = new URL("http://google.com");
        try {
            TextJarReader reader = new TextJarReader(url.toString());
        }
        catch (IOException ioe) {
            TextJarReaderTest.assertTrue((boolean)true);
            return;
        }
        TextJarReaderTest.fail((String)("didn't catch an expected exception for url: " + url.toString()));
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(TextJarReaderTest.class));
    }
}

