/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.actions.GinyUtils;
import cytoscape.data.CyAttributes;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import ding.view.DGraphView;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;

public class DestroySelectedAction
extends CytoscapeAction {
    public DestroySelectedAction() {
        super("Delete Selected Nodes/Edges");
        this.setPreferredMenu("Edit");
    }

    public DestroySelectedAction(boolean label) {
    }

    public void actionPerformed(ActionEvent e) {
        String callerID = "DeleteSelectedAction.actionPerformed";
        CyNetworkView networkView = Cytoscape.getCurrentNetworkView();
        List edgeViews = networkView.getSelectedEdges();
        List nodeViews = networkView.getSelectedNodes();
        final CyNetwork cyNet = networkView.getNetwork();
        final int[] nodes = new int[nodeViews.size() + 1];
        int[] allEdges = new int[]{};
        final Node[] cyNodes = new Node[nodeViews.size()];
        for (int i = 0; i < nodeViews.size(); ++i) {
            int nodeIdx;
            NodeView nview = (NodeView)nodeViews.get(i);
            Node n = nview.getNode();
            Point2D offset = nview.getOffset();
            if (offset != null) {
                double[] nextLocn = new double[]{offset.getX(), offset.getY()};
                ((DGraphView)Cytoscape.getCurrentNetworkView()).xformComponentToNodeCoords(nextLocn);
                CyAttributes nodeAttribs = Cytoscape.getNodeAttributes();
                nodeAttribs.setAttribute(n.getIdentifier(), "X_pos", new Double(nextLocn[0]));
                nodeAttribs.setAttribute(n.getIdentifier(), "Y_pos", new Double(nextLocn[1]));
            }
            nodes[i] = nodeIdx = cyNodes[i].getRootGraphIndex();
            int[] edgesList = cyNet.getAdjacentEdgeIndicesArray(nodeIdx, true, true, true);
            int[] bigEdges = new int[allEdges.length + edgesList.length];
            for (int m = 0; m < allEdges.length; ++m) {
                bigEdges[m] = allEdges[m];
            }
            for (int p = 0; p < edgesList.length; ++p) {
                bigEdges[allEdges.length + p] = edgesList[p];
            }
            allEdges = bigEdges;
        }
        for (int j = 0; j < edgeViews.size(); ++j) {
            EdgeView eview = (EdgeView)edgeViews.get(j);
            CyEdge cyEdge = (CyEdge)eview.getEdge();
            int edgeIdx = cyEdge.getRootGraphIndex();
            int[] bigEdges = new int[allEdges.length + 1];
            for (int m = 0; m < allEdges.length; ++m) {
                bigEdges[m] = allEdges[m];
            }
            bigEdges[allEdges.length] = edgeIdx;
            allEdges = bigEdges;
        }
        final int[] edges = allEdges;
        for (int i = 0; i < edges.length; ++i) {
            cyNet.removeEdge(edges[i], false);
        }
        for (int j = 0; j < nodes.length; ++j) {
            cyNet.removeNode(nodes[j], false);
        }
        networkView.redrawGraph(false, false);
        StringBuilder stringBuilder = new StringBuilder().append("adding undoableEdit to undoManager: ");
        Cytoscape.getDesktop();
        System.out.println(stringBuilder.append(CytoscapeDesktop.undo).toString());
        Cytoscape.getDesktop();
        CytoscapeDesktop.undo.addEdit(new AbstractUndoableEdit(){
            final String network_id;
            {
                this.network_id = cyNet.getIdentifier();
            }

            public String getPresentationName() {
                return "Remove";
            }

            public String getRedoPresentationName() {
                if (edges.length == 0) {
                    return "Redo: Removed Nodes";
                }
                return "Redo: Removed Nodes and Edges";
            }

            public String getUndoPresentationName() {
                if (edges.length == 0) {
                    return "Undo: Removed Nodes";
                }
                return "Undo: Removed Nodes and Edges";
            }

            public void redo() {
                super.redo();
                CyNetwork network = Cytoscape.getNetwork(this.network_id);
                for (int i = 0; i < edges.length; ++i) {
                    network.removeEdge(edges[i], false);
                }
                for (int j = 0; j < nodes.length; ++j) {
                    network.removeNode(nodes[j], false);
                }
            }

            public void undo() {
                super.undo();
                CyNetwork network = Cytoscape.getNetwork(this.network_id);
                if (network != null) {
                    network.restoreNodes(nodes);
                    network.restoreEdges(edges);
                    GinyUtils.unHideAll(Cytoscape.getCurrentNetworkView());
                    for (int i = 0; i < nodes.length; ++i) {
                        Node n = network.getNode(nodes[i]);
                        CyAttributes nodeAttribs = Cytoscape.getNodeAttributes();
                        Double xPos = nodeAttribs.getDoubleAttribute(n.getIdentifier(), "X_pos");
                        Double yPos = nodeAttribs.getDoubleAttribute(n.getIdentifier(), "Y_pos");
                        if (xPos == null || yPos == null) continue;
                        NodeView nv = Cytoscape.getCurrentNetworkView().getNodeView(cyNodes[i]);
                        nv.setOffset(xPos.doubleValue(), yPos.doubleValue());
                    }
                }
            }
        });
        Cytoscape.firePropertyChange("NETWORK_MODIFIED", null, cyNet);
    }
}

