/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.Appearance;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.calculators.Calculator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AppearanceCalculator
implements Cloneable {
    List<Calculator> calcs = new ArrayList<Calculator>();
    protected Appearance tmpDefaultAppearance;

    public Object clone() {
        Object copy = null;
        try {
            copy = super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Error cloning!");
        }
        return copy;
    }

    public AppearanceCalculator() {
    }

    public AppearanceCalculator(String name, Properties nacProps, String baseKey, CalculatorCatalog catalog, Appearance appr) {
        this.tmpDefaultAppearance = appr;
        this.applyProperties(appr, name, nacProps, baseKey, catalog);
    }

    public AppearanceCalculator(AppearanceCalculator toCopy) {
        if (toCopy == null) {
            return;
        }
        for (Calculator c : toCopy.getCalculators()) {
            this.setCalculator(c);
        }
        this.copyDefaultAppearance(toCopy);
    }

    public Calculator getCalculator(byte type) {
        for (Calculator nc : this.calcs) {
            if (nc.getType() != type) continue;
            return nc;
        }
        return null;
    }

    public List<Calculator> getCalculators() {
        return this.calcs;
    }

    public void removeCalculator(byte type) {
        Calculator toRemove = null;
        for (Calculator c : this.calcs) {
            if (c.getType() != type) continue;
            toRemove = c;
            break;
        }
        this.calcs.remove(toRemove);
    }

    public void setCalculator(Calculator c) {
        if (c == null) {
            return;
        }
        if (!this.isValidCalculator(c)) {
            return;
        }
        Calculator toReplace = null;
        for (Calculator nc : this.calcs) {
            if (nc.getType() != c.getType()) continue;
            toReplace = nc;
            break;
        }
        if (toReplace != null) {
            this.calcs.remove(toReplace);
        }
        this.calcs.add(c);
    }

    protected String getDescription(String name, Appearance defaultAppr) {
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(name + ":" + lineSep);
        sb.append(defaultAppr.getDescription("default")).append(lineSep);
        for (Calculator c : this.calcs) {
            sb.append(((Object)c).toString()).append(lineSep);
        }
        return sb.toString();
    }

    protected void applyProperties(Appearance appr, String name, Properties nacProps, String baseKey, CalculatorCatalog catalog) {
        String value = null;
        appr.applyDefaultProperties(nacProps, baseKey);
        for (Byte b : catalog.getCalculatorTypes()) {
            for (Calculator c : catalog.getCalculators(b)) {
                value = nacProps.getProperty(baseKey + "." + c.getPropertyLabel());
                Calculator newCalc = catalog.getCalculator(c.getType(), value);
                this.setCalculator(newCalc);
            }
        }
    }

    protected Properties getProperties(Appearance appr, String baseKey) {
        String key = null;
        String value = null;
        Properties newProps = appr.getDefaultProperties(baseKey);
        for (Calculator c : this.calcs) {
            key = baseKey + "." + c.getPropertyLabel();
            value = ((Object)c).toString();
            newProps.setProperty(key, value);
        }
        return newProps;
    }

    protected abstract void copyDefaultAppearance(AppearanceCalculator var1);

    protected abstract boolean isValidCalculator(Calculator var1);
}

