/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.ui.FontRenderer;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class FontChooser
extends JPanel {
    private Font selectedFont;
    protected DefaultComboBoxModel fontFaceModel;
    protected JComboBox face;
    protected static float displaySize = 12.0f;
    protected static Font[] scaledFonts;
    protected static Font defFont;

    public FontChooser() {
        this((Font)null);
    }

    public FontChooser(Font def) {
        this(scaledFonts, def);
    }

    public FontChooser(Font[] srcFonts, Font def) {
        Font[] displayFonts = scaledFonts;
        if (srcFonts != scaledFonts) {
            System.out.println("scaling fonts");
            displayFonts = FontChooser.scaleFonts(srcFonts, displaySize);
        }
        this.fontFaceModel = new DefaultComboBoxModel<Font>(displayFonts);
        this.face = new JComboBox(this.fontFaceModel);
        this.face.setRenderer(new FontRenderer());
        this.face.addItemListener(new FontFaceSelectionListener());
        this.selectedFont = def == null ? defFont : def.deriveFont(1.0f);
        this.face.setSelectedItem(this.selectedFont);
        this.add(this.face);
    }

    public JComboBox getFaceComboBox() {
        return this.face;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    private static Font[] scaleFonts(Font[] inFonts, float size) {
        Font[] outFonts = new Font[inFonts.length];
        int i = 0;
        for (Font f : inFonts) {
            outFonts[i++] = f.deriveFont(size);
        }
        return outFonts;
    }

    static {
        defFont = new Font("dialog", 0, 1);
        scaledFonts = FontChooser.scaleFonts(GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts(), displaySize);
    }

    private class FontFaceSelectionListener
    implements ItemListener {
        private FontFaceSelectionListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                JComboBox source = (JComboBox)e.getItemSelectable();
                FontChooser.this.selectedFont = (Font)source.getSelectedItem();
            }
        }
    }
}

