/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.readers.AnnotationFlatFileReader;
import cytoscape.data.annotation.readers.OntologyFlatFileReader;
import cytoscape.data.servers.BioDataServer;
import java.io.File;

public class loadAnnotationFromFlatFiles {
    public static void main(String[] args) throws Exception {
        File ontologyFile;
        if (args.length != 3) {
            System.err.println("usage:  loadAnnotationFromFaltFile <server name> <annotation.txt> <ontology.txt>");
            System.exit(1);
        }
        String serverName = args[0];
        BioDataServer server = new BioDataServer(serverName);
        String annotationFilename = args[1];
        String ontologyFilename = args[2];
        File annotationFile = new File(annotationFilename);
        if (!annotationFile.canRead()) {
            System.err.println("--- cytoscape.data.servers.loadAnnotationFromFlatfiles error:  cannot read");
            System.err.println("        " + annotationFilename);
            System.exit(1);
        }
        if (!(ontologyFile = new File(ontologyFilename)).canRead()) {
            System.err.println("--- cytoscape.data.servers.loadAnnotationFromFlatfiles error:  cannot read");
            System.err.println("        " + ontologyFilename);
            System.exit(1);
        }
        AnnotationFlatFileReader reader = new AnnotationFlatFileReader(annotationFile);
        Annotation annotation = reader.getAnnotation();
        OntologyFlatFileReader ontologyReader = new OntologyFlatFileReader(ontologyFile);
        Ontology ontology = ontologyReader.getOntology();
        if (!annotation.getCurator().equals(ontology.getCurator())) {
            System.err.println("annotation is curated by " + annotation.getCurator());
            System.err.println("ontology is curated by " + ontology.getCurator());
            System.err.println(" --> these disagree.  Exiting....");
            System.exit(1);
        }
        annotation.setOntology(ontology);
        server.addAnnotation(annotation);
        System.out.println(server.describe());
    }
}

