/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class SimpleAlignment
extends AbstractSymbolList
implements Alignment,
Serializable {
    private static final long serialVersionUID = -1760075176220928440L;
    private LinkedHashMap labelToSymbolList;
    private List labels;
    private Alphabet alphabet;
    private int length;

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public int length() {
        return this.length;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public Symbol symbolAt(int index) {
        try {
            if (this.labels.size() == 1) {
                return this.symbolAt(this.labels.get(0), index);
            }
            return this.alphabet.getSymbol(new ColAsList(index));
        }
        catch (IllegalSymbolException ire) {
            throw new BioError("Somehow my crossproduct alphabet is incompatible with column " + index, ire);
        }
    }

    public List getLabels() {
        return this.labels;
    }

    public Symbol symbolAt(Object label, int column) {
        return this.symbolListForLabel(label).symbolAt(column);
    }

    public Alignment subAlignment(Set labels, Location loc) throws NoSuchElementException {
        LinkedHashMap labelsToResList = new LinkedHashMap();
        Iterator i = labels != null ? labels.iterator() : this.getLabels().iterator();
        while (i.hasNext()) {
            Object label = i.next();
            SymbolList sym = this.symbolListForLabel(label);
            if (loc != null) {
                sym = loc.symbols(sym);
            }
            labelsToResList.put(label, sym);
        }
        return new SimpleAlignment(labelsToResList);
    }

    public SymbolList symbolListForLabel(Object label) throws NoSuchElementException {
        SymbolList rl = (SymbolList)this.labelToSymbolList.get(label);
        if (rl == null) {
            throw new NoSuchElementException("No symbol list associated with label " + label);
        }
        return rl;
    }

    public SimpleAlignment(Map labelToResList) throws IllegalArgumentException {
        if (labelToResList.isEmpty()) {
            throw new IllegalArgumentException("Can't create an alignment with no sequences");
        }
        this.labels = Collections.unmodifiableList(new ArrayList(labelToResList.keySet()));
        this.labelToSymbolList = new LinkedHashMap(labelToResList);
        int length = -1;
        ArrayList<Alphabet> alphaList = new ArrayList<Alphabet>();
        Iterator li = this.labels.iterator();
        while (li.hasNext()) {
            Object label = li.next();
            try {
                SymbolList rl = this.symbolListForLabel(label);
                alphaList.add(rl.getAlphabet());
                if (length == -1) {
                    length = rl.length();
                    continue;
                }
                if (rl.length() == length) continue;
                StringBuffer sb = new StringBuffer();
                Iterator labI = this.labels.iterator();
                while (labI.hasNext()) {
                    Object lab = labI.next();
                    sb.append("\n\t" + lab + " (" + this.symbolListForLabel(lab).length() + ")");
                }
                throw new IllegalArgumentException("All SymbolLists must be the same length: " + sb.substring(0));
            }
            catch (NoSuchElementException nsee) {
                if (this.labelToSymbolList.containsKey(label)) {
                    throw new IllegalArgumentException("The symbol list associated with " + label + " is null");
                }
                throw new BioError("Something is screwey - map is lying about key/values", nsee);
            }
        }
        this.alphabet = AlphabetManager.getCrossProductAlphabet(alphaList);
        this.length = length;
    }

    public Iterator symbolListIterator() {
        return new Alignment.SymbolListIterator(this);
    }

    private final class ColAsList
    extends AbstractList
    implements Serializable {
        private final int col;

        public ColAsList(int col) {
            this.col = col;
        }

        protected ColAsList() {
            this.col = 0;
        }

        public Object get(int indx) {
            return SimpleAlignment.this.symbolAt(SimpleAlignment.this.labels.get(indx), this.col);
        }

        public int size() {
            return SimpleAlignment.this.labels.size();
        }
    }
}

