/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.agave;

import java.util.ListIterator;
import org.biojava.bio.seq.io.agave.AGAVEDbId;
import org.biojava.bio.seq.io.agave.AGAVEDbIdCallbackItf;
import org.biojava.bio.seq.io.agave.AGAVEDbIdPropHandler;
import org.biojava.bio.seq.io.agave.AGAVEFeatureCallbackItf;
import org.biojava.bio.seq.io.agave.AGAVEQueryRegion;
import org.biojava.bio.seq.io.agave.ElementRecognizer;
import org.biojava.bio.seq.io.agave.StAXContentHandler;
import org.biojava.bio.seq.io.agave.StAXFeatureHandler;
import org.biojava.bio.seq.io.agave.StAXHandlerFactory;
import org.biojava.bio.symbol.RangeLocation;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AGAVEQueryRegionPropHandler
extends StAXFeatureHandler
implements AGAVEDbIdCallbackItf {
    public static final StAXHandlerFactory AGAVE_QUERY_REGION_PROP_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new AGAVEQueryRegionPropHandler(staxenv);
        }
    };
    private int start;
    private int end;
    private AGAVEQueryRegion region;

    AGAVEQueryRegionPropHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        this.setHandlerCharacteristics("query_region", true);
        super.addHandler(new ElementRecognizer.ByLocalName("db_id"), AGAVEDbIdPropHandler.AGAVE_DBID_PROP_HANDLER_FACTORY);
        this.region = new AGAVEQueryRegion();
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.region.setStart(new Integer(attrs.getValue("start")));
        this.region.setEnd(new Integer(attrs.getValue("end")));
    }

    public void addDbId(AGAVEDbId db_id) {
        try {
            this.region.setDbId(db_id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        try {
            this.staxenv.featureTemplate.annotation.setProperty("query_region", this.region);
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
        int currLevel = this.staxenv.getLevel();
        if (currLevel >= 1) {
            ListIterator li = this.staxenv.getHandlerStackIterator(currLevel);
            while (li.hasPrevious()) {
                Object ob = li.previous();
                if (!(ob instanceof AGAVEFeatureCallbackItf)) continue;
                ((AGAVEFeatureCallbackItf)ob).reportFeature(new RangeLocation(this.region.getStart(), this.region.getEnd()));
                return;
            }
        }
    }
}

