package org.baderlab.lola.view;

import org.baderlab.lola.model.ProfileSet;
import org.baderlab.lola.model.LogoGenerator;
import org.baderlab.lola.model.Profile;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.brain.PeptideToProfileReader;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProfileSearchProjectFile;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import java.io.IOException;

/**
 Copyright 2007 Bader Lab

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: May 28, 2007
 * Time: 6:04:25 PM
 * To change this template use File | Settings | File Templates.
 */
public class MakeLogosFromProfileSetAction implements ActionListener {
    private ProfileSet profileSet;
    LolaParameterSet paramSet;

    public MakeLogosFromProfileSetAction(ProfileSet profileSet, LolaParameterSet params) {
        super();
        this.profileSet = profileSet;
        this.paramSet = params;

    }
    
    public void actionPerformed(ActionEvent actionEvent) {
        boolean isProjectFile = false;

        //determine if we're dealing with a project file or a single protein profile
        ProfileSearchProjectFile profileProjectFile = new ProfileSearchProjectFile();
        try {
            if (profileProjectFile.isProjectFile(paramSet.getProfileFile().toString())) {
                isProjectFile = true;
            }
        } catch (IOException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }

        //read profile(s) from the profile file using given parameters
        // (a single protein profile or a set of profiles linked from a project file)
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(
                paramSet.getProfileFile(),
                paramSet.getFuzzFactor(),
                paramSet.getCodonBiasFile(),
                paramSet.getUniquePeptides());

        //if we're opening a new project file, clear the profile set
        // as only one project file at a time can be processed (for now)
//        if (isProjectFile) {
            profileSet.clear();
//        }
        

        //generate logo image(s) for the profile(s)
        for (int i = 0; i < profileList.size(); i++) {
            ProteinProfile proteinProfile = (ProteinProfile) profileList.get(i);

            //generate logo image
            BufferedImage image = LogoGenerator.generateImage(
                    proteinProfile,
                    paramSet,
                    "_logo");

            //set the logo profile and add it to the profile set
            Profile profile = new Profile();
            profile.set(proteinProfile);
            profile.setImage(image);
            profileSet.addElement(profile);
            
        }

    }
}
