package org.baderlab.lola.model;

import com.lowagie.text.pdf.*;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.IOException;

import org.baderlab.brain.LogoTreeDraw;

/**
 Copyright 2007 Bader Lab

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: Jul 24, 2007
 * Time: 11:48:05 PM
 * To change this template use File | Settings | File Templates.
 */
public class LogoTree {

/**
 * TODO - modify BRAIN library to return a Graphics2D object containing the logo tree and store it here (2007 July 24)
 * This would be a modification of BrainAlgorithm.runProfileCluster that wouldn't go as far as producing a PDF
 *  but would just return the graphics object
 */

    private String outputFilePath;          //the filesystem path of the output file (if tree was saved to disk)
    private boolean isSaved;                //true iff tree was saved to 'outputFile'
    private BufferedImage treeImage;        //the image of the logo tree
    private LogoTreeDraw logoTreeDraw;


    public void LogoTree() {
        outputFilePath = null;
        isSaved = false;
        treeImage = null;
    }

    /**
     * Sets the filesystem path of the file in which the logo tree is or will be saved.
     * @param path String containing the filesystem path
     */
    public void setOutputFilePath(String path) {
        this.outputFilePath = path;
    }

    /**
     * Returns the filesystem path of the file in which the logo tree is or will be saved.
     * @return String containing the the filesystem path
     */
    public String getOutputPath() {
        return this.outputFilePath;
    }

    /**
     * Sets the flag indicating whether or not the logo tree was saved to a disk file.
     * @param flag boolean
     */
    public void setIsSaved(boolean flag) {
        this.isSaved = flag;
    }

    /**
     * Returns a flag indicated whether or not the logo tree was saved to a disk file.
     * @return boolean
     */
    public boolean getIsSaved() {
        return this.isSaved;
    }

    /**
     * Sets the image of the logo tree
     * @param image BufferedImage
     */
    public void setImage(BufferedImage image) {
        this.treeImage = image;
    }

    /**
     * Sets the 2D graphics of the logo tree
     * @param ltd BufferedImage
     */
    public void setLogoTreeDraw(LogoTreeDraw ltd) {
        this.logoTreeDraw = ltd;
    }

    /**
     * Gets the image of the logo tree if generated; or null otherwise
     * @return BufferedImage
     */
    public BufferedImage getImage() {
        return this.treeImage;
    }

    /**
     * Gets the image of the logo tree if generated; or null otherwise
     * @return LogoTreeDraw
     */
    public LogoTreeDraw getLogoTreeDraw() {
        return this.logoTreeDraw;
    }



    /*
    A failed attempt at reading an image from a logo tree PDF document.
    TODO - decide if we want to pursue this or just use the BufferedImage 'treeImage'
     */
    public java.awt.Image imageFromPDF() {

        try {
            if (this.isSaved) {
                PdfReader reader = new PdfReader(this.outputFilePath);
                PdfObject pdfObject = reader.getPdfObject(1);
                if (!pdfObject.isStream()) {
                    throw new Exception("Tyring to read image from a non-stream PDF file: " + this.outputFilePath);
                }
                PdfStream stream = (PdfStream) pdfObject;
                PdfObject pdfsubtype = stream.get(PdfName.SUBTYPE);
                if (pdfsubtype == null) {
                     throw new Exception("Not an image stream");
                }
                if (!pdfsubtype.toString().equals(PdfName.IMAGE.toString())) {
                     throw new Exception("Not an image stream");
                }
                // now you have a PDF stream object with an image
                byte[] img = PdfReader.getStreamBytesRaw((PRStream) stream);
                java.awt.Image i = Toolkit.getDefaultToolkit().createImage(img);
                return i;
            }

        } catch (IOException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

}
