package org.baderlab.lola.view.actions;

import org.baderlab.lola.model.ProfileSet;
import org.baderlab.lola.model.LogoTree;
import org.baderlab.lola.model.LogoGenerator;
import org.baderlab.lola.LolaParameterSet;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.io.*;

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: Aug 20, 2007
 * Time: 1:02:11 AM
 * To change this template use File | Settings | File Templates.
 */
public class SaveLogoTreeToFile implements ActionListener {
    private ProfileSet profileSet;
    LolaParameterSet paramSet;

    public SaveLogoTreeToFile(ProfileSet profileSet, LolaParameterSet params) {
        super();
        this.profileSet = profileSet;
        this.paramSet = params;

    }

    public void actionPerformed(ActionEvent actionEvent) {
        LogoTree tree = profileSet.getLogoTree();
        if (tree != null) {

            try {
                LogoGenerator.saveGraphicAsPDF(new File(tree.getOutputPath()), tree.getLogoTreeDraw(),
                        tree.getImage().getWidth(), tree.getImage().getHeight());

            } catch (IOException e) {
                e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
            }

            tree.setIsSaved(true);
        }
    }
}
