package org.baderlab.lola.model;

import org.baderlab.brain.ProteinProfile;

import java.util.List;
import java.awt.image.BufferedImage;

/**
 Copyright 2007 Bader Lab

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: May 29, 2007
 * Time: 5:50:22 PM
 */

public class Profile {
    private String name = null;
    private ProteinProfile proteinProfile;
    private BufferedImage logoImage;

    //constructor from superclass
//    public Profile(List list, String s) {
//        super(list, s);
//    }

    public ProteinProfile get() {
        return proteinProfile;
    }

    public void set(ProteinProfile profile) {
        proteinProfile = profile;
        name = profile.getName() + " (" + profile.getNumColumns() + " positions, " + profile.getNumSequences() + " peptides)";
    }

    public ProteinProfile getProteinProfile() {
        return proteinProfile;
    }

    public String getName() {
        return name;
    }

    public BufferedImage getImage() {
        return logoImage;
    }
    public void setImage(BufferedImage image) {
        logoImage = image;
    }

    public String toString() {
        return name;
    }

    public Profile copy() {
        Profile p = new Profile();
        p.set(proteinProfile);
        p.setImage(logoImage);
        return p;
    }

    public void setFuzzFactor(double factor) {
//        proteinProfile
    }

}
