/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.AbstractCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.ObjectMapping;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;

public class VizMapPropertiesTest
extends TestCase {
    public void testProperties() {
        CalculatorCatalog catalog = new CalculatorCatalog();
        Properties props = new Properties();
        try {
            String propsFile = "resources/props/vizmap.props";
            FileInputStream is = new FileInputStream(propsFile);
            props.load(is);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        CalculatorIO.loadCalculators(props, catalog);
        Collection nodeColorCalcs = catalog.getNodeColorCalculators();
        System.out.println("nodeColorCalcs.size() = " + nodeColorCalcs.size());
        this.checkCalculator(catalog.getNodeColorCalculator("RedGreen"));
        System.out.println();
        Collection nodeLineTypeCalcs = catalog.getNodeLineTypeCalculators();
        System.out.println("nodeLineTypeCalcs.size() = " + nodeLineTypeCalcs.size());
        this.checkCalculator(catalog.getNodeLineTypeCalculator("BasicDiscrete"));
        this.checkCalculator(catalog.getNodeLineTypeCalculator("BasicContinuous"));
        System.out.println();
        Collection nodeShapeCalcs = catalog.getNodeShapeCalculators();
        System.out.println("nodeShapeCalcs.size() = " + nodeShapeCalcs.size());
        this.checkCalculator(catalog.getNodeShapeCalculator("BasicDiscrete"));
        this.checkCalculator(catalog.getNodeShapeCalculator("BasicContinuous"));
        System.out.println();
        Collection nodeSizeCalcs = catalog.getNodeSizeCalculators();
        System.out.println("nodeSizeCalcs.size() = " + nodeSizeCalcs.size());
        this.checkCalculator(catalog.getNodeSizeCalculator("BasicDiscrete"));
        this.checkCalculator(catalog.getNodeSizeCalculator("BasicContinuous"));
        System.out.println();
        Collection nodeLabelCalcs = catalog.getNodeLabelCalculators();
        System.out.println("nodeLabelCalcs.size() = " + nodeLabelCalcs.size());
        this.checkCalculator(catalog.getNodeLabelCalculator("BasicDiscrete"));
        this.checkCalculator(catalog.getNodeLabelCalculator("BasicContinuous"));
        System.out.println();
        Collection nodeToolTipCalcs = catalog.getNodeToolTipCalculators();
        System.out.println("nodeToolTipCalcs.size() = " + nodeToolTipCalcs.size());
        this.checkCalculator(catalog.getNodeToolTipCalculator("BasicDiscrete"));
        this.checkCalculator(catalog.getNodeToolTipCalculator("BasicContinuous"));
        System.out.println();
        Collection nodeFontFaceCalcs = catalog.getNodeFontFaceCalculators();
        System.out.println("nodeFontFaceCalcs.size() = " + nodeFontFaceCalcs.size());
        this.checkCalculator(catalog.getNodeFontFaceCalculator("BasicDiscrete"));
        this.checkCalculator(catalog.getNodeFontFaceCalculator("BasicContinuous"));
        System.out.println();
        Collection nodeFontSizeCalcs = catalog.getNodeFontSizeCalculators();
        System.out.println("nodeFontSizeCalcs.size() = " + nodeFontSizeCalcs.size());
        this.checkCalculator(catalog.getNodeFontSizeCalculator("BasicDiscrete"));
        this.checkCalculator(catalog.getNodeFontSizeCalculator("BasicContinuous"));
        System.out.println();
        Collection edgeColorCalcs = catalog.getEdgeColorCalculators();
        System.out.println("edgeColorCalcs.size() = " + edgeColorCalcs.size());
        this.checkCalculator(catalog.getEdgeColorCalculator("BasicDiscrete"));
        System.out.println();
        Collection edgeLineTypeCalcs = catalog.getEdgeLineTypeCalculators();
        System.out.println("edgeLineTypeCalcs.size() = " + edgeLineTypeCalcs.size());
        this.checkCalculator(catalog.getEdgeLineTypeCalculator("BasicDiscrete"));
        this.checkCalculator(catalog.getEdgeLineTypeCalculator("BasicContinuous"));
        System.out.println();
        Collection edgeArrowCalcs = catalog.getEdgeArrowCalculators();
        System.out.println("edgeArrowCalcs.size() = " + edgeArrowCalcs.size());
        this.checkCalculator(catalog.getEdgeArrowCalculator("BasicDiscrete"));
        this.checkCalculator(catalog.getEdgeArrowCalculator("BasicContinuous"));
        System.out.println();
        Collection edgeLabelCalcs = catalog.getEdgeLabelCalculators();
        System.out.println("edgeLabelCalcs.size() = " + edgeLabelCalcs.size());
        this.checkCalculator(catalog.getEdgeLabelCalculator("BasicDiscrete"));
        this.checkCalculator(catalog.getEdgeLabelCalculator("BasicContinuous"));
        this.checkCalculator(catalog.getEdgeLabelCalculator("testPassThrough"));
        System.out.println();
        Collection edgeToolTipCalcs = catalog.getEdgeToolTipCalculators();
        System.out.println("edgeToolTipCalcs.size() = " + edgeToolTipCalcs.size());
        this.checkCalculator(catalog.getEdgeToolTipCalculator("BasicDiscrete"));
        this.checkCalculator(catalog.getEdgeToolTipCalculator("BasicContinuous"));
        System.out.println();
        Collection edgeFontFaceCalcs = catalog.getEdgeFontFaceCalculators();
        System.out.println("edgeFontFaceCalcs.size() = " + edgeFontFaceCalcs.size());
        this.checkCalculator(catalog.getEdgeFontFaceCalculator("BasicDiscrete"));
        this.checkCalculator(catalog.getEdgeFontFaceCalculator("BasicContinuous"));
        System.out.println();
        Collection edgeFontSizeCalcs = catalog.getEdgeFontSizeCalculators();
        System.out.println("edgeFontSizeCalcs.size() = " + edgeFontSizeCalcs.size());
        this.checkCalculator(catalog.getEdgeFontSizeCalculator("BasicDiscrete"));
        this.checkCalculator(catalog.getEdgeFontSizeCalculator("BasicContinuous"));
        System.out.println();
        for (VisualStyle style : catalog.getVisualStyles()) {
            System.out.println(style.getName());
            System.out.println();
        }
    }

    private void checkCalculator(Calculator c) {
        if (c == null) {
            VizMapPropertiesTest.fail();
        }
        AbstractCalculator gc = (AbstractCalculator)c;
        ObjectMapping m = gc.getMapping(0);
        System.out.println("controller = " + m.getControllingAttributeName());
        System.out.println("Map = " + m);
    }
}

